package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetCallDataByJobGroupId invokes the cloudcallcenter.GetCallDataByJobGroupId API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/getcalldatabyjobgroupid.html
func (client *Client) GetCallDataByJobGroupId(request *GetCallDataByJobGroupIdRequest) (response *GetCallDataByJobGroupIdResponse, err error) {
	response = CreateGetCallDataByJobGroupIdResponse()
	err = client.DoAction(request, response)
	return
}

// GetCallDataByJobGroupIdWithChan invokes the cloudcallcenter.GetCallDataByJobGroupId API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/getcalldatabyjobgroupid.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetCallDataByJobGroupIdWithChan(request *GetCallDataByJobGroupIdRequest) (<-chan *GetCallDataByJobGroupIdResponse, <-chan error) {
	responseChan := make(chan *GetCallDataByJobGroupIdResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetCallDataByJobGroupId(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetCallDataByJobGroupIdWithCallback invokes the cloudcallcenter.GetCallDataByJobGroupId API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/getcalldatabyjobgroupid.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetCallDataByJobGroupIdWithCallback(request *GetCallDataByJobGroupIdRequest, callback func(response *GetCallDataByJobGroupIdResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetCallDataByJobGroupIdResponse
		var err error
		defer close(result)
		response, err = client.GetCallDataByJobGroupId(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetCallDataByJobGroupIdRequest is the request struct for api GetCallDataByJobGroupId
type GetCallDataByJobGroupIdRequest struct {
	*requests.RpcRequest
	InstanceId string `position:"Query" name:"InstanceId"`
	JobGroupId string `position:"Query" name:"JobGroupId"`
}

// GetCallDataByJobGroupIdResponse is the response struct for api GetCallDataByJobGroupId
type GetCallDataByJobGroupIdResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	SuccessNumber  string `json:"SuccessNumber" xml:"SuccessNumber"`
	TotalNumber    string `json:"TotalNumber" xml:"TotalNumber"`
	LossNumber     string `json:"LossNumber" xml:"LossNumber"`
}

// CreateGetCallDataByJobGroupIdRequest creates a request to invoke GetCallDataByJobGroupId API
func CreateGetCallDataByJobGroupIdRequest() (request *GetCallDataByJobGroupIdRequest) {
	request = &GetCallDataByJobGroupIdRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "GetCallDataByJobGroupId", "", "")
	request.Method = requests.POST
	return
}

// CreateGetCallDataByJobGroupIdResponse creates a response to parse from GetCallDataByJobGroupId response
func CreateGetCallDataByJobGroupIdResponse() (response *GetCallDataByJobGroupIdResponse) {
	response = &GetCallDataByJobGroupIdResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
