package cloudesl

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AssignUser invokes the cloudesl.AssignUser API synchronously
func (client *Client) AssignUser(request *AssignUserRequest) (response *AssignUserResponse, err error) {
	response = CreateAssignUserResponse()
	err = client.DoAction(request, response)
	return
}

// AssignUserWithChan invokes the cloudesl.AssignUser API asynchronously
func (client *Client) AssignUserWithChan(request *AssignUserRequest) (<-chan *AssignUserResponse, <-chan error) {
	responseChan := make(chan *AssignUserResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AssignUser(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AssignUserWithCallback invokes the cloudesl.AssignUser API asynchronously
func (client *Client) AssignUserWithCallback(request *AssignUserRequest, callback func(response *AssignUserResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AssignUserResponse
		var err error
		defer close(result)
		response, err = client.AssignUser(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AssignUserRequest is the request struct for api AssignUser
type AssignUserRequest struct {
	*requests.RpcRequest
	ExtraParams string `position:"Body" name:"ExtraParams"`
	Stores      string `position:"Body" name:"Stores"`
	UserType    string `position:"Body" name:"UserType"`
	UserId      string `position:"Body" name:"UserId"`
}

// AssignUserResponse is the response struct for api AssignUser
type AssignUserResponse struct {
	*responses.BaseResponse
	ErrorMessage   string `json:"ErrorMessage" xml:"ErrorMessage"`
	ErrorCode      string `json:"ErrorCode" xml:"ErrorCode"`
	Message        string `json:"Message" xml:"Message"`
	DynamicCode    string `json:"DynamicCode" xml:"DynamicCode"`
	Code           string `json:"Code" xml:"Code"`
	DynamicMessage string `json:"DynamicMessage" xml:"DynamicMessage"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
}

// CreateAssignUserRequest creates a request to invoke AssignUser API
func CreateAssignUserRequest() (request *AssignUserRequest) {
	request = &AssignUserRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudesl", "2020-02-01", "AssignUser", "", "")
	request.Method = requests.POST
	return
}

// CreateAssignUserResponse creates a response to parse from AssignUser response
func CreateAssignUserResponse() (response *AssignUserResponse) {
	response = &AssignUserResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
