package config

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetAdvancedSearchFile invokes the config.GetAdvancedSearchFile API synchronously
func (client *Client) GetAdvancedSearchFile(request *GetAdvancedSearchFileRequest) (response *GetAdvancedSearchFileResponse, err error) {
	response = CreateGetAdvancedSearchFileResponse()
	err = client.DoAction(request, response)
	return
}

// GetAdvancedSearchFileWithChan invokes the config.GetAdvancedSearchFile API asynchronously
func (client *Client) GetAdvancedSearchFileWithChan(request *GetAdvancedSearchFileRequest) (<-chan *GetAdvancedSearchFileResponse, <-chan error) {
	responseChan := make(chan *GetAdvancedSearchFileResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetAdvancedSearchFile(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetAdvancedSearchFileWithCallback invokes the config.GetAdvancedSearchFile API asynchronously
func (client *Client) GetAdvancedSearchFileWithCallback(request *GetAdvancedSearchFileRequest, callback func(response *GetAdvancedSearchFileResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetAdvancedSearchFileResponse
		var err error
		defer close(result)
		response, err = client.GetAdvancedSearchFile(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetAdvancedSearchFileRequest is the request struct for api GetAdvancedSearchFile
type GetAdvancedSearchFileRequest struct {
	*requests.RpcRequest
}

// GetAdvancedSearchFileResponse is the response struct for api GetAdvancedSearchFile
type GetAdvancedSearchFileResponse struct {
	*responses.BaseResponse
	RequestId      string         `json:"RequestId" xml:"RequestId"`
	ResourceSearch ResourceSearch `json:"ResourceSearch" xml:"ResourceSearch"`
}

// CreateGetAdvancedSearchFileRequest creates a request to invoke GetAdvancedSearchFile API
func CreateGetAdvancedSearchFileRequest() (request *GetAdvancedSearchFileRequest) {
	request = &GetAdvancedSearchFileRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Config", "2020-09-07", "GetAdvancedSearchFile", "", "")
	request.Method = requests.POST
	return
}

// CreateGetAdvancedSearchFileResponse creates a response to parse from GetAdvancedSearchFile response
func CreateGetAdvancedSearchFileResponse() (response *GetAdvancedSearchFileResponse) {
	response = &GetAdvancedSearchFileResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
