package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListEnabledExtensionsForProject invokes the dataworks_public.ListEnabledExtensionsForProject API synchronously
func (client *Client) ListEnabledExtensionsForProject(request *ListEnabledExtensionsForProjectRequest) (response *ListEnabledExtensionsForProjectResponse, err error) {
	response = CreateListEnabledExtensionsForProjectResponse()
	err = client.DoAction(request, response)
	return
}

// ListEnabledExtensionsForProjectWithChan invokes the dataworks_public.ListEnabledExtensionsForProject API asynchronously
func (client *Client) ListEnabledExtensionsForProjectWithChan(request *ListEnabledExtensionsForProjectRequest) (<-chan *ListEnabledExtensionsForProjectResponse, <-chan error) {
	responseChan := make(chan *ListEnabledExtensionsForProjectResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListEnabledExtensionsForProject(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListEnabledExtensionsForProjectWithCallback invokes the dataworks_public.ListEnabledExtensionsForProject API asynchronously
func (client *Client) ListEnabledExtensionsForProjectWithCallback(request *ListEnabledExtensionsForProjectRequest, callback func(response *ListEnabledExtensionsForProjectResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListEnabledExtensionsForProjectResponse
		var err error
		defer close(result)
		response, err = client.ListEnabledExtensionsForProject(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListEnabledExtensionsForProjectRequest is the request struct for api ListEnabledExtensionsForProject
type ListEnabledExtensionsForProjectRequest struct {
	*requests.RpcRequest
	EventCode string           `position:"Body" name:"EventCode"`
	FileType  string           `position:"Body" name:"FileType"`
	ProjectId requests.Integer `position:"Body" name:"ProjectId"`
}

// ListEnabledExtensionsForProjectResponse is the response struct for api ListEnabledExtensionsForProject
type ListEnabledExtensionsForProjectResponse struct {
	*responses.BaseResponse
	RequestId  string           `json:"RequestId" xml:"RequestId"`
	Extensions []ExtensionsItem `json:"Extensions" xml:"Extensions"`
}

// CreateListEnabledExtensionsForProjectRequest creates a request to invoke ListEnabledExtensionsForProject API
func CreateListEnabledExtensionsForProjectRequest() (request *ListEnabledExtensionsForProjectRequest) {
	request = &ListEnabledExtensionsForProjectRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "ListEnabledExtensionsForProject", "", "")
	request.Method = requests.POST
	return
}

// CreateListEnabledExtensionsForProjectResponse creates a response to parse from ListEnabledExtensionsForProject response
func CreateListEnabledExtensionsForProjectResponse() (response *ListEnabledExtensionsForProjectResponse) {
	response = &ListEnabledExtensionsForProjectResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
