package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDomainViewTopCostTime invokes the ddoscoo.DescribeDomainViewTopCostTime API synchronously
func (client *Client) DescribeDomainViewTopCostTime(request *DescribeDomainViewTopCostTimeRequest) (response *DescribeDomainViewTopCostTimeResponse, err error) {
	response = CreateDescribeDomainViewTopCostTimeResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDomainViewTopCostTimeWithChan invokes the ddoscoo.DescribeDomainViewTopCostTime API asynchronously
func (client *Client) DescribeDomainViewTopCostTimeWithChan(request *DescribeDomainViewTopCostTimeRequest) (<-chan *DescribeDomainViewTopCostTimeResponse, <-chan error) {
	responseChan := make(chan *DescribeDomainViewTopCostTimeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDomainViewTopCostTime(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDomainViewTopCostTimeWithCallback invokes the ddoscoo.DescribeDomainViewTopCostTime API asynchronously
func (client *Client) DescribeDomainViewTopCostTimeWithCallback(request *DescribeDomainViewTopCostTimeRequest, callback func(response *DescribeDomainViewTopCostTimeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDomainViewTopCostTimeResponse
		var err error
		defer close(result)
		response, err = client.DescribeDomainViewTopCostTime(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDomainViewTopCostTimeRequest is the request struct for api DescribeDomainViewTopCostTime
type DescribeDomainViewTopCostTimeRequest struct {
	*requests.RpcRequest
	StartTime       requests.Integer `position:"Query" name:"StartTime"`
	ResourceGroupId string           `position:"Query" name:"ResourceGroupId"`
	SourceIp        string           `position:"Query" name:"SourceIp"`
	Top             requests.Integer `position:"Query" name:"Top"`
	EndTime         requests.Integer `position:"Query" name:"EndTime"`
	Domain          string           `position:"Query" name:"Domain"`
}

// DescribeDomainViewTopCostTimeResponse is the response struct for api DescribeDomainViewTopCostTime
type DescribeDomainViewTopCostTimeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	UrlList   []Url  `json:"UrlList" xml:"UrlList"`
}

// CreateDescribeDomainViewTopCostTimeRequest creates a request to invoke DescribeDomainViewTopCostTime API
func CreateDescribeDomainViewTopCostTimeRequest() (request *DescribeDomainViewTopCostTimeRequest) {
	request = &DescribeDomainViewTopCostTimeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2020-01-01", "DescribeDomainViewTopCostTime", "ddoscoo", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeDomainViewTopCostTimeResponse creates a response to parse from DescribeDomainViewTopCostTime response
func CreateDescribeDomainViewTopCostTimeResponse() (response *DescribeDomainViewTopCostTimeResponse) {
	response = &DescribeDomainViewTopCostTimeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
