package dds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeGlobalSecurityIPGroupRelation invokes the dds.DescribeGlobalSecurityIPGroupRelation API synchronously
func (client *Client) DescribeGlobalSecurityIPGroupRelation(request *DescribeGlobalSecurityIPGroupRelationRequest) (response *DescribeGlobalSecurityIPGroupRelationResponse, err error) {
	response = CreateDescribeGlobalSecurityIPGroupRelationResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeGlobalSecurityIPGroupRelationWithChan invokes the dds.DescribeGlobalSecurityIPGroupRelation API asynchronously
func (client *Client) DescribeGlobalSecurityIPGroupRelationWithChan(request *DescribeGlobalSecurityIPGroupRelationRequest) (<-chan *DescribeGlobalSecurityIPGroupRelationResponse, <-chan error) {
	responseChan := make(chan *DescribeGlobalSecurityIPGroupRelationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeGlobalSecurityIPGroupRelation(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeGlobalSecurityIPGroupRelationWithCallback invokes the dds.DescribeGlobalSecurityIPGroupRelation API asynchronously
func (client *Client) DescribeGlobalSecurityIPGroupRelationWithCallback(request *DescribeGlobalSecurityIPGroupRelationRequest, callback func(response *DescribeGlobalSecurityIPGroupRelationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeGlobalSecurityIPGroupRelationResponse
		var err error
		defer close(result)
		response, err = client.DescribeGlobalSecurityIPGroupRelation(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeGlobalSecurityIPGroupRelationRequest is the request struct for api DescribeGlobalSecurityIPGroupRelation
type DescribeGlobalSecurityIPGroupRelationRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceGroupId      string           `position:"Query" name:"ResourceGroupId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	DBClusterId          string           `position:"Query" name:"DBClusterId"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeGlobalSecurityIPGroupRelationResponse is the response struct for api DescribeGlobalSecurityIPGroupRelation
type DescribeGlobalSecurityIPGroupRelationResponse struct {
	*responses.BaseResponse
	DBClusterId              string                         `json:"DBClusterId" xml:"DBClusterId"`
	RequestId                string                         `json:"RequestId" xml:"RequestId"`
	GlobalSecurityIPGroupRel []GlobalSecurityIPGroupRelItem `json:"GlobalSecurityIPGroupRel" xml:"GlobalSecurityIPGroupRel"`
}

// CreateDescribeGlobalSecurityIPGroupRelationRequest creates a request to invoke DescribeGlobalSecurityIPGroupRelation API
func CreateDescribeGlobalSecurityIPGroupRelationRequest() (request *DescribeGlobalSecurityIPGroupRelationRequest) {
	request = &DescribeGlobalSecurityIPGroupRelationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dds", "2015-12-01", "DescribeGlobalSecurityIPGroupRelation", "dds", "openAPI")
	request.Method = requests.GET
	return
}

// CreateDescribeGlobalSecurityIPGroupRelationResponse creates a response to parse from DescribeGlobalSecurityIPGroupRelation response
func CreateDescribeGlobalSecurityIPGroupRelationResponse() (response *DescribeGlobalSecurityIPGroupRelationResponse) {
	response = &DescribeGlobalSecurityIPGroupRelationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
