package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CloseOrder invokes the dms_enterprise.CloseOrder API synchronously
// api document: https://help.aliyun.com/api/dms-enterprise/closeorder.html
func (client *Client) CloseOrder(request *CloseOrderRequest) (response *CloseOrderResponse, err error) {
	response = CreateCloseOrderResponse()
	err = client.DoAction(request, response)
	return
}

// CloseOrderWithChan invokes the dms_enterprise.CloseOrder API asynchronously
// api document: https://help.aliyun.com/api/dms-enterprise/closeorder.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CloseOrderWithChan(request *CloseOrderRequest) (<-chan *CloseOrderResponse, <-chan error) {
	responseChan := make(chan *CloseOrderResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CloseOrder(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CloseOrderWithCallback invokes the dms_enterprise.CloseOrder API asynchronously
// api document: https://help.aliyun.com/api/dms-enterprise/closeorder.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CloseOrderWithCallback(request *CloseOrderRequest, callback func(response *CloseOrderResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CloseOrderResponse
		var err error
		defer close(result)
		response, err = client.CloseOrder(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CloseOrderRequest is the request struct for api CloseOrder
type CloseOrderRequest struct {
	*requests.RpcRequest
	OrderId     requests.Integer `position:"Query" name:"OrderId"`
	CloseReason string           `position:"Query" name:"CloseReason"`
	Tid         requests.Integer `position:"Query" name:"Tid"`
}

// CloseOrderResponse is the response struct for api CloseOrder
type CloseOrderResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	ErrorCode    string `json:"ErrorCode" xml:"ErrorCode"`
}

// CreateCloseOrderRequest creates a request to invoke CloseOrder API
func CreateCloseOrderRequest() (request *CloseOrderRequest) {
	request = &CloseOrderRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "CloseOrder", "dmsenterprise", "openAPI")
	return
}

// CreateCloseOrderResponse creates a response to parse from CloseOrder response
func CreateCloseOrderResponse() (response *CloseOrderResponse) {
	response = &CloseOrderResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
