package eais

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateEaisEi invokes the eais.CreateEaisEi API synchronously
func (client *Client) CreateEaisEi(request *CreateEaisEiRequest) (response *CreateEaisEiResponse, err error) {
	response = CreateCreateEaisEiResponse()
	err = client.DoAction(request, response)
	return
}

// CreateEaisEiWithChan invokes the eais.CreateEaisEi API asynchronously
func (client *Client) CreateEaisEiWithChan(request *CreateEaisEiRequest) (<-chan *CreateEaisEiResponse, <-chan error) {
	responseChan := make(chan *CreateEaisEiResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateEaisEi(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateEaisEiWithCallback invokes the eais.CreateEaisEi API asynchronously
func (client *Client) CreateEaisEiWithCallback(request *CreateEaisEiRequest, callback func(response *CreateEaisEiResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateEaisEiResponse
		var err error
		defer close(result)
		response, err = client.CreateEaisEi(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateEaisEiRequest is the request struct for api CreateEaisEi
type CreateEaisEiRequest struct {
	*requests.RpcRequest
	ClientToken     string             `position:"Query" name:"ClientToken"`
	SecurityGroupId string             `position:"Query" name:"SecurityGroupId"`
	ResourceGroupId string             `position:"Query" name:"ResourceGroupId"`
	InstanceType    string             `position:"Query" name:"InstanceType"`
	Tag             *[]CreateEaisEiTag `position:"Query" name:"Tag"  type:"Repeated"`
	VSwitchId       string             `position:"Query" name:"VSwitchId"`
	InstanceName    string             `position:"Query" name:"InstanceName"`
}

// CreateEaisEiTag is a repeated param struct in CreateEaisEiRequest
type CreateEaisEiTag struct {
	Value string `name:"Value"`
	Key   string `name:"Key"`
}

// CreateEaisEiResponse is the response struct for api CreateEaisEi
type CreateEaisEiResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	EiInstanceId string `json:"EiInstanceId" xml:"EiInstanceId"`
}

// CreateCreateEaisEiRequest creates a request to invoke CreateEaisEi API
func CreateCreateEaisEiRequest() (request *CreateEaisEiRequest) {
	request = &CreateEaisEiRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("eais", "2019-06-24", "CreateEaisEi", "eais", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateEaisEiResponse creates a response to parse from CreateEaisEi response
func CreateCreateEaisEiResponse() (response *CreateEaisEiResponse) {
	response = &CreateEaisEiResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
