package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeCloudDriveGroups invokes the ecd.DescribeCloudDriveGroups API synchronously
func (client *Client) DescribeCloudDriveGroups(request *DescribeCloudDriveGroupsRequest) (response *DescribeCloudDriveGroupsResponse, err error) {
	response = CreateDescribeCloudDriveGroupsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeCloudDriveGroupsWithChan invokes the ecd.DescribeCloudDriveGroups API asynchronously
func (client *Client) DescribeCloudDriveGroupsWithChan(request *DescribeCloudDriveGroupsRequest) (<-chan *DescribeCloudDriveGroupsResponse, <-chan error) {
	responseChan := make(chan *DescribeCloudDriveGroupsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeCloudDriveGroups(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeCloudDriveGroupsWithCallback invokes the ecd.DescribeCloudDriveGroups API asynchronously
func (client *Client) DescribeCloudDriveGroupsWithCallback(request *DescribeCloudDriveGroupsRequest, callback func(response *DescribeCloudDriveGroupsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeCloudDriveGroupsResponse
		var err error
		defer close(result)
		response, err = client.DescribeCloudDriveGroups(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeCloudDriveGroupsRequest is the request struct for api DescribeCloudDriveGroups
type DescribeCloudDriveGroupsRequest struct {
	*requests.RpcRequest
	ParentGroupId string           `position:"Query" name:"ParentGroupId"`
	GroupType     string           `position:"Query" name:"GroupType"`
	DriveType     string           `position:"Query" name:"DriveType"`
	NextToken     string           `position:"Query" name:"NextToken"`
	DirectoryId   string           `position:"Query" name:"DirectoryId"`
	GroupId       *[]string        `position:"Query" name:"GroupId"  type:"Repeated"`
	DirectoryName string           `position:"Query" name:"DirectoryName"`
	GroupName     string           `position:"Query" name:"GroupName"`
	CdsId         string           `position:"Query" name:"CdsId"`
	DriveStatus   string           `position:"Query" name:"DriveStatus"`
	MaxResults    requests.Integer `position:"Query" name:"MaxResults"`
}

// DescribeCloudDriveGroupsResponse is the response struct for api DescribeCloudDriveGroups
type DescribeCloudDriveGroupsResponse struct {
	*responses.BaseResponse
	NextToken        string            `json:"NextToken" xml:"NextToken"`
	RequestId        string            `json:"RequestId" xml:"RequestId"`
	Count            int64             `json:"Count" xml:"Count"`
	Success          bool              `json:"Success" xml:"Success"`
	CloudDriveGroups []CloudDriveGroup `json:"CloudDriveGroups" xml:"CloudDriveGroups"`
}

// CreateDescribeCloudDriveGroupsRequest creates a request to invoke DescribeCloudDriveGroups API
func CreateDescribeCloudDriveGroupsRequest() (request *DescribeCloudDriveGroupsRequest) {
	request = &DescribeCloudDriveGroupsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "DescribeCloudDriveGroups", "gwsecd", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeCloudDriveGroupsResponse creates a response to parse from DescribeCloudDriveGroups response
func CreateDescribeCloudDriveGroupsResponse() (response *DescribeCloudDriveGroupsResponse) {
	response = &DescribeCloudDriveGroupsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
