package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeCloudDrivePermissions invokes the ecd.DescribeCloudDrivePermissions API synchronously
func (client *Client) DescribeCloudDrivePermissions(request *DescribeCloudDrivePermissionsRequest) (response *DescribeCloudDrivePermissionsResponse, err error) {
	response = CreateDescribeCloudDrivePermissionsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeCloudDrivePermissionsWithChan invokes the ecd.DescribeCloudDrivePermissions API asynchronously
func (client *Client) DescribeCloudDrivePermissionsWithChan(request *DescribeCloudDrivePermissionsRequest) (<-chan *DescribeCloudDrivePermissionsResponse, <-chan error) {
	responseChan := make(chan *DescribeCloudDrivePermissionsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeCloudDrivePermissions(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeCloudDrivePermissionsWithCallback invokes the ecd.DescribeCloudDrivePermissions API asynchronously
func (client *Client) DescribeCloudDrivePermissionsWithCallback(request *DescribeCloudDrivePermissionsRequest, callback func(response *DescribeCloudDrivePermissionsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeCloudDrivePermissionsResponse
		var err error
		defer close(result)
		response, err = client.DescribeCloudDrivePermissions(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeCloudDrivePermissionsRequest is the request struct for api DescribeCloudDrivePermissions
type DescribeCloudDrivePermissionsRequest struct {
	*requests.RpcRequest
	CdsId string `position:"Query" name:"CdsId"`
}

// DescribeCloudDrivePermissionsResponse is the response struct for api DescribeCloudDrivePermissions
type DescribeCloudDrivePermissionsResponse struct {
	*responses.BaseResponse
	RequestId                  string                      `json:"RequestId" xml:"RequestId"`
	CloudDrivePermissionModels []CloudDrivePermissionModel `json:"CloudDrivePermissionModels" xml:"CloudDrivePermissionModels"`
}

// CreateDescribeCloudDrivePermissionsRequest creates a request to invoke DescribeCloudDrivePermissions API
func CreateDescribeCloudDrivePermissionsRequest() (request *DescribeCloudDrivePermissionsRequest) {
	request = &DescribeCloudDrivePermissionsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "DescribeCloudDrivePermissions", "gwsecd", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeCloudDrivePermissionsResponse creates a response to parse from DescribeCloudDrivePermissions response
func CreateDescribeCloudDrivePermissionsResponse() (response *DescribeCloudDrivePermissionsResponse) {
	response = &DescribeCloudDrivePermissionsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
