package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeSessionStatistic invokes the ecd.DescribeSessionStatistic API synchronously
func (client *Client) DescribeSessionStatistic(request *DescribeSessionStatisticRequest) (response *DescribeSessionStatisticResponse, err error) {
	response = CreateDescribeSessionStatisticResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeSessionStatisticWithChan invokes the ecd.DescribeSessionStatistic API asynchronously
func (client *Client) DescribeSessionStatisticWithChan(request *DescribeSessionStatisticRequest) (<-chan *DescribeSessionStatisticResponse, <-chan error) {
	responseChan := make(chan *DescribeSessionStatisticResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeSessionStatistic(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeSessionStatisticWithCallback invokes the ecd.DescribeSessionStatistic API asynchronously
func (client *Client) DescribeSessionStatisticWithCallback(request *DescribeSessionStatisticRequest, callback func(response *DescribeSessionStatisticResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeSessionStatisticResponse
		var err error
		defer close(result)
		response, err = client.DescribeSessionStatistic(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeSessionStatisticRequest is the request struct for api DescribeSessionStatistic
type DescribeSessionStatisticRequest struct {
	*requests.RpcRequest
	OfficeSiteId   string           `position:"Query" name:"OfficeSiteId"`
	Period         requests.Integer `position:"Query" name:"Period"`
	EndTime        string           `position:"Query" name:"EndTime"`
	StartTime      string           `position:"Query" name:"StartTime"`
	SearchRegionId string           `position:"Query" name:"SearchRegionId"`
}

// DescribeSessionStatisticResponse is the response struct for api DescribeSessionStatistic
type DescribeSessionStatisticResponse struct {
	*responses.BaseResponse
	TotalCount string          `json:"TotalCount" xml:"TotalCount"`
	RequestId  string          `json:"RequestId" xml:"RequestId"`
	Statistic  []StatisticItem `json:"Statistic" xml:"Statistic"`
}

// CreateDescribeSessionStatisticRequest creates a request to invoke DescribeSessionStatistic API
func CreateDescribeSessionStatisticRequest() (request *DescribeSessionStatisticRequest) {
	request = &DescribeSessionStatisticRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "DescribeSessionStatistic", "gwsecd", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeSessionStatisticResponse creates a response to parse from DescribeSessionStatistic response
func CreateDescribeSessionStatisticResponse() (response *DescribeSessionStatisticResponse) {
	response = &DescribeSessionStatisticResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
