package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// WakeupDesktops invokes the ecd.WakeupDesktops API synchronously
func (client *Client) WakeupDesktops(request *WakeupDesktopsRequest) (response *WakeupDesktopsResponse, err error) {
	response = CreateWakeupDesktopsResponse()
	err = client.DoAction(request, response)
	return
}

// WakeupDesktopsWithChan invokes the ecd.WakeupDesktops API asynchronously
func (client *Client) WakeupDesktopsWithChan(request *WakeupDesktopsRequest) (<-chan *WakeupDesktopsResponse, <-chan error) {
	responseChan := make(chan *WakeupDesktopsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.WakeupDesktops(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// WakeupDesktopsWithCallback invokes the ecd.WakeupDesktops API asynchronously
func (client *Client) WakeupDesktopsWithCallback(request *WakeupDesktopsRequest, callback func(response *WakeupDesktopsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *WakeupDesktopsResponse
		var err error
		defer close(result)
		response, err = client.WakeupDesktops(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// WakeupDesktopsRequest is the request struct for api WakeupDesktops
type WakeupDesktopsRequest struct {
	*requests.RpcRequest
	DesktopId *[]string `position:"Query" name:"DesktopId"  type:"Repeated"`
}

// WakeupDesktopsResponse is the response struct for api WakeupDesktops
type WakeupDesktopsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateWakeupDesktopsRequest creates a request to invoke WakeupDesktops API
func CreateWakeupDesktopsRequest() (request *WakeupDesktopsRequest) {
	request = &WakeupDesktopsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "WakeupDesktops", "gwsecd", "openAPI")
	request.Method = requests.POST
	return
}

// CreateWakeupDesktopsResponse creates a response to parse from WakeupDesktops response
func CreateWakeupDesktopsResponse() (response *WakeupDesktopsResponse) {
	response = &WakeupDesktopsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
