package eflo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateVpd invokes the eflo.CreateVpd API synchronously
func (client *Client) CreateVpd(request *CreateVpdRequest) (response *CreateVpdResponse, err error) {
	response = CreateCreateVpdResponse()
	err = client.DoAction(request, response)
	return
}

// CreateVpdWithChan invokes the eflo.CreateVpd API asynchronously
func (client *Client) CreateVpdWithChan(request *CreateVpdRequest) (<-chan *CreateVpdResponse, <-chan error) {
	responseChan := make(chan *CreateVpdResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateVpd(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateVpdWithCallback invokes the eflo.CreateVpd API asynchronously
func (client *Client) CreateVpdWithCallback(request *CreateVpdRequest, callback func(response *CreateVpdResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateVpdResponse
		var err error
		defer close(result)
		response, err = client.CreateVpd(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateVpdRequest is the request struct for api CreateVpd
type CreateVpdRequest struct {
	*requests.RpcRequest
	VpdName         string              `position:"Body" name:"VpdName"`
	ResourceGroupId string              `position:"Body" name:"ResourceGroupId"`
	Cidr            string              `position:"Body" name:"Cidr"`
	Subnets         *[]CreateVpdSubnets `position:"Body" name:"Subnets"  type:"Repeated"`
	Tag             *[]CreateVpdTag     `position:"Body" name:"Tag"  type:"Repeated"`
}

// CreateVpdSubnets is a repeated param struct in CreateVpdRequest
type CreateVpdSubnets struct {
	RegionId   string `name:"RegionId"`
	ZoneId     string `name:"ZoneId"`
	Cidr       string `name:"Cidr"`
	SubnetName string `name:"SubnetName"`
	Type       string `name:"Type"`
}

// CreateVpdTag is a repeated param struct in CreateVpdRequest
type CreateVpdTag struct {
	Value string `name:"Value"`
	Key   string `name:"Key"`
}

// CreateVpdResponse is the response struct for api CreateVpd
type CreateVpdResponse struct {
	*responses.BaseResponse
	Code      int     `json:"Code" xml:"Code"`
	Message   string  `json:"Message" xml:"Message"`
	RequestId string  `json:"RequestId" xml:"RequestId"`
	Content   Content `json:"Content" xml:"Content"`
}

// CreateCreateVpdRequest creates a request to invoke CreateVpd API
func CreateCreateVpdRequest() (request *CreateVpdRequest) {
	request = &CreateVpdRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("eflo", "2022-05-30", "CreateVpd", "eflo", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateVpdResponse creates a response to parse from CreateVpd response
func CreateCreateVpdResponse() (response *CreateVpdResponse) {
	response = &CreateVpdResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
