package eflo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetLniPrivateIpAddress invokes the eflo.GetLniPrivateIpAddress API synchronously
func (client *Client) GetLniPrivateIpAddress(request *GetLniPrivateIpAddressRequest) (response *GetLniPrivateIpAddressResponse, err error) {
	response = CreateGetLniPrivateIpAddressResponse()
	err = client.DoAction(request, response)
	return
}

// GetLniPrivateIpAddressWithChan invokes the eflo.GetLniPrivateIpAddress API asynchronously
func (client *Client) GetLniPrivateIpAddressWithChan(request *GetLniPrivateIpAddressRequest) (<-chan *GetLniPrivateIpAddressResponse, <-chan error) {
	responseChan := make(chan *GetLniPrivateIpAddressResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetLniPrivateIpAddress(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetLniPrivateIpAddressWithCallback invokes the eflo.GetLniPrivateIpAddress API asynchronously
func (client *Client) GetLniPrivateIpAddressWithCallback(request *GetLniPrivateIpAddressRequest, callback func(response *GetLniPrivateIpAddressResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetLniPrivateIpAddressResponse
		var err error
		defer close(result)
		response, err = client.GetLniPrivateIpAddress(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetLniPrivateIpAddressRequest is the request struct for api GetLniPrivateIpAddress
type GetLniPrivateIpAddressRequest struct {
	*requests.RpcRequest
	IpName             string `position:"Body" name:"IpName"`
	NetworkInterfaceId string `position:"Body" name:"NetworkInterfaceId"`
}

// GetLniPrivateIpAddressResponse is the response struct for api GetLniPrivateIpAddress
type GetLniPrivateIpAddressResponse struct {
	*responses.BaseResponse
	Code      int     `json:"Code" xml:"Code"`
	Message   string  `json:"Message" xml:"Message"`
	RequestId string  `json:"RequestId" xml:"RequestId"`
	Content   Content `json:"Content" xml:"Content"`
}

// CreateGetLniPrivateIpAddressRequest creates a request to invoke GetLniPrivateIpAddress API
func CreateGetLniPrivateIpAddressRequest() (request *GetLniPrivateIpAddressRequest) {
	request = &GetLniPrivateIpAddressRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("eflo", "2022-05-30", "GetLniPrivateIpAddress", "eflo", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetLniPrivateIpAddressResponse creates a response to parse from GetLniPrivateIpAddress response
func CreateGetLniPrivateIpAddressResponse() (response *GetLniPrivateIpAddressResponse) {
	response = &GetLniPrivateIpAddressResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
