package idrsservice

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateTaskGroup invokes the idrsservice.CreateTaskGroup API synchronously
func (client *Client) CreateTaskGroup(request *CreateTaskGroupRequest) (response *CreateTaskGroupResponse, err error) {
	response = CreateCreateTaskGroupResponse()
	err = client.DoAction(request, response)
	return
}

// CreateTaskGroupWithChan invokes the idrsservice.CreateTaskGroup API asynchronously
func (client *Client) CreateTaskGroupWithChan(request *CreateTaskGroupRequest) (<-chan *CreateTaskGroupResponse, <-chan error) {
	responseChan := make(chan *CreateTaskGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateTaskGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateTaskGroupWithCallback invokes the idrsservice.CreateTaskGroup API asynchronously
func (client *Client) CreateTaskGroupWithCallback(request *CreateTaskGroupRequest, callback func(response *CreateTaskGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateTaskGroupResponse
		var err error
		defer close(result)
		response, err = client.CreateTaskGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateTaskGroupRequest is the request struct for api CreateTaskGroup
type CreateTaskGroupRequest struct {
	*requests.RpcRequest
	ClientToken      string    `position:"Query" name:"ClientToken"`
	ExpireAt         string    `position:"Query" name:"ExpireAt"`
	Day              *[]string `position:"Query" name:"Day"  type:"Repeated"`
	RunnableTimeTo   string    `position:"Query" name:"RunnableTimeTo"`
	TriggerPeriod    string    `position:"Query" name:"TriggerPeriod"`
	GroupName        string    `position:"Query" name:"GroupName"`
	VideoUrl         *[]string `position:"Query" name:"VideoUrl"  type:"Repeated"`
	AppId            string    `position:"Query" name:"AppId"`
	RunnableTimeFrom string    `position:"Query" name:"RunnableTimeFrom"`
	RuleId           string    `position:"Query" name:"RuleId"`
}

// CreateTaskGroupResponse is the response struct for api CreateTaskGroup
type CreateTaskGroupResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateCreateTaskGroupRequest creates a request to invoke CreateTaskGroup API
func CreateCreateTaskGroupRequest() (request *CreateTaskGroupRequest) {
	request = &CreateTaskGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("idrsservice", "2020-06-30", "CreateTaskGroup", "idrsservice", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateTaskGroupResponse creates a response to parse from CreateTaskGroup response
func CreateCreateTaskGroupResponse() (response *CreateTaskGroupResponse) {
	response = &CreateTaskGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
