package ims

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListOIDCProviders invokes the ims.ListOIDCProviders API synchronously
func (client *Client) ListOIDCProviders(request *ListOIDCProvidersRequest) (response *ListOIDCProvidersResponse, err error) {
	response = CreateListOIDCProvidersResponse()
	err = client.DoAction(request, response)
	return
}

// ListOIDCProvidersWithChan invokes the ims.ListOIDCProviders API asynchronously
func (client *Client) ListOIDCProvidersWithChan(request *ListOIDCProvidersRequest) (<-chan *ListOIDCProvidersResponse, <-chan error) {
	responseChan := make(chan *ListOIDCProvidersResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListOIDCProviders(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListOIDCProvidersWithCallback invokes the ims.ListOIDCProviders API asynchronously
func (client *Client) ListOIDCProvidersWithCallback(request *ListOIDCProvidersRequest, callback func(response *ListOIDCProvidersResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListOIDCProvidersResponse
		var err error
		defer close(result)
		response, err = client.ListOIDCProviders(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListOIDCProvidersRequest is the request struct for api ListOIDCProviders
type ListOIDCProvidersRequest struct {
	*requests.RpcRequest
	AkProxySuffix string           `position:"Query" name:"AkProxySuffix"`
	Marker        string           `position:"Query" name:"Marker"`
	MaxItems      requests.Integer `position:"Query" name:"MaxItems"`
}

// ListOIDCProvidersResponse is the response struct for api ListOIDCProviders
type ListOIDCProvidersResponse struct {
	*responses.BaseResponse
	RequestId     string        `json:"RequestId" xml:"RequestId"`
	IsTruncated   bool          `json:"IsTruncated" xml:"IsTruncated"`
	Marker        string        `json:"Marker" xml:"Marker"`
	OIDCProviders OIDCProviders `json:"OIDCProviders" xml:"OIDCProviders"`
}

// CreateListOIDCProvidersRequest creates a request to invoke ListOIDCProviders API
func CreateListOIDCProvidersRequest() (request *ListOIDCProvidersRequest) {
	request = &ListOIDCProvidersRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ims", "2019-08-15", "ListOIDCProviders", "ims", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListOIDCProvidersResponse creates a response to parse from ListOIDCProviders response
func CreateListOIDCProvidersResponse() (response *ListOIDCProvidersResponse) {
	response = &ListOIDCProvidersResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
