package linkvisual

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryRecordPlanDeviceByDevice invokes the linkvisual.QueryRecordPlanDeviceByDevice API synchronously
func (client *Client) QueryRecordPlanDeviceByDevice(request *QueryRecordPlanDeviceByDeviceRequest) (response *QueryRecordPlanDeviceByDeviceResponse, err error) {
	response = CreateQueryRecordPlanDeviceByDeviceResponse()
	err = client.DoAction(request, response)
	return
}

// QueryRecordPlanDeviceByDeviceWithChan invokes the linkvisual.QueryRecordPlanDeviceByDevice API asynchronously
func (client *Client) QueryRecordPlanDeviceByDeviceWithChan(request *QueryRecordPlanDeviceByDeviceRequest) (<-chan *QueryRecordPlanDeviceByDeviceResponse, <-chan error) {
	responseChan := make(chan *QueryRecordPlanDeviceByDeviceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryRecordPlanDeviceByDevice(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryRecordPlanDeviceByDeviceWithCallback invokes the linkvisual.QueryRecordPlanDeviceByDevice API asynchronously
func (client *Client) QueryRecordPlanDeviceByDeviceWithCallback(request *QueryRecordPlanDeviceByDeviceRequest, callback func(response *QueryRecordPlanDeviceByDeviceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryRecordPlanDeviceByDeviceResponse
		var err error
		defer close(result)
		response, err = client.QueryRecordPlanDeviceByDevice(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryRecordPlanDeviceByDeviceRequest is the request struct for api QueryRecordPlanDeviceByDevice
type QueryRecordPlanDeviceByDeviceRequest struct {
	*requests.RpcRequest
	IotId         string           `position:"Query" name:"IotId"`
	IotInstanceId string           `position:"Query" name:"IotInstanceId"`
	StreamType    requests.Integer `position:"Query" name:"StreamType"`
	ProductKey    string           `position:"Query" name:"ProductKey"`
	ApiProduct    string           `position:"Body" name:"ApiProduct"`
	ApiRevision   string           `position:"Body" name:"ApiRevision"`
	DeviceName    string           `position:"Query" name:"DeviceName"`
}

// QueryRecordPlanDeviceByDeviceResponse is the response struct for api QueryRecordPlanDeviceByDevice
type QueryRecordPlanDeviceByDeviceResponse struct {
	*responses.BaseResponse
	Code         string `json:"Code" xml:"Code"`
	RequestId    string `json:"RequestId" xml:"RequestId"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Success      bool   `json:"Success" xml:"Success"`
	Data         Data   `json:"Data" xml:"Data"`
}

// CreateQueryRecordPlanDeviceByDeviceRequest creates a request to invoke QueryRecordPlanDeviceByDevice API
func CreateQueryRecordPlanDeviceByDeviceRequest() (request *QueryRecordPlanDeviceByDeviceRequest) {
	request = &QueryRecordPlanDeviceByDeviceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Linkvisual", "2018-01-20", "QueryRecordPlanDeviceByDevice", "Linkvisual", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryRecordPlanDeviceByDeviceResponse creates a response to parse from QueryRecordPlanDeviceByDevice response
func CreateQueryRecordPlanDeviceByDeviceResponse() (response *QueryRecordPlanDeviceByDeviceResponse) {
	response = &QueryRecordPlanDeviceByDeviceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
