package linkwan

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CountRentedJoinPermissions invokes the linkwan.CountRentedJoinPermissions API synchronously
func (client *Client) CountRentedJoinPermissions(request *CountRentedJoinPermissionsRequest) (response *CountRentedJoinPermissionsResponse, err error) {
	response = CreateCountRentedJoinPermissionsResponse()
	err = client.DoAction(request, response)
	return
}

// CountRentedJoinPermissionsWithChan invokes the linkwan.CountRentedJoinPermissions API asynchronously
func (client *Client) CountRentedJoinPermissionsWithChan(request *CountRentedJoinPermissionsRequest) (<-chan *CountRentedJoinPermissionsResponse, <-chan error) {
	responseChan := make(chan *CountRentedJoinPermissionsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CountRentedJoinPermissions(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CountRentedJoinPermissionsWithCallback invokes the linkwan.CountRentedJoinPermissions API asynchronously
func (client *Client) CountRentedJoinPermissionsWithCallback(request *CountRentedJoinPermissionsRequest, callback func(response *CountRentedJoinPermissionsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CountRentedJoinPermissionsResponse
		var err error
		defer close(result)
		response, err = client.CountRentedJoinPermissions(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CountRentedJoinPermissionsRequest is the request struct for api CountRentedJoinPermissions
type CountRentedJoinPermissionsRequest struct {
	*requests.RpcRequest
	Type                    string           `position:"Query" name:"Type"`
	Enabled                 requests.Boolean `position:"Query" name:"Enabled"`
	FuzzyJoinEui            string           `position:"Query" name:"FuzzyJoinEui"`
	FuzzyJoinPermissionName string           `position:"Query" name:"FuzzyJoinPermissionName"`
	BoundNodeGroup          requests.Boolean `position:"Query" name:"BoundNodeGroup"`
	ApiProduct              string           `position:"Body" name:"ApiProduct"`
	ApiRevision             string           `position:"Body" name:"ApiRevision"`
	FuzzyOwnerAliyunId      string           `position:"Query" name:"FuzzyOwnerAliyunId"`
}

// CountRentedJoinPermissionsResponse is the response struct for api CountRentedJoinPermissions
type CountRentedJoinPermissionsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      int64  `json:"Data" xml:"Data"`
}

// CreateCountRentedJoinPermissionsRequest creates a request to invoke CountRentedJoinPermissions API
func CreateCountRentedJoinPermissionsRequest() (request *CountRentedJoinPermissionsRequest) {
	request = &CountRentedJoinPermissionsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("LinkWAN", "2019-03-01", "CountRentedJoinPermissions", "linkwan", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCountRentedJoinPermissionsResponse creates a response to parse from CountRentedJoinPermissions response
func CreateCountRentedJoinPermissionsResponse() (response *CountRentedJoinPermissionsResponse) {
	response = &CountRentedJoinPermissionsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
