package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteEventSub invokes the live.DeleteEventSub API synchronously
func (client *Client) DeleteEventSub(request *DeleteEventSubRequest) (response *DeleteEventSubResponse, err error) {
	response = CreateDeleteEventSubResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteEventSubWithChan invokes the live.DeleteEventSub API asynchronously
func (client *Client) DeleteEventSubWithChan(request *DeleteEventSubRequest) (<-chan *DeleteEventSubResponse, <-chan error) {
	responseChan := make(chan *DeleteEventSubResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteEventSub(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteEventSubWithCallback invokes the live.DeleteEventSub API asynchronously
func (client *Client) DeleteEventSubWithCallback(request *DeleteEventSubRequest, callback func(response *DeleteEventSubResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteEventSubResponse
		var err error
		defer close(result)
		response, err = client.DeleteEventSub(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteEventSubRequest is the request struct for api DeleteEventSub
type DeleteEventSubRequest struct {
	*requests.RpcRequest
	SubscribeId string `position:"Query" name:"SubscribeId"`
	AppId       string `position:"Query" name:"AppId"`
}

// DeleteEventSubResponse is the response struct for api DeleteEventSub
type DeleteEventSubResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteEventSubRequest creates a request to invoke DeleteEventSub API
func CreateDeleteEventSubRequest() (request *DeleteEventSubRequest) {
	request = &DeleteEventSubRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "DeleteEventSub", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteEventSubResponse creates a response to parse from DeleteEventSub response
func CreateDeleteEventSubResponse() (response *DeleteEventSubResponse) {
	response = &DeleteEventSubResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
