package mns_open

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetQueueAttributes invokes the mns_open.GetQueueAttributes API synchronously
func (client *Client) GetQueueAttributes(request *GetQueueAttributesRequest) (response *GetQueueAttributesResponse, err error) {
	response = CreateGetQueueAttributesResponse()
	err = client.DoAction(request, response)
	return
}

// GetQueueAttributesWithChan invokes the mns_open.GetQueueAttributes API asynchronously
func (client *Client) GetQueueAttributesWithChan(request *GetQueueAttributesRequest) (<-chan *GetQueueAttributesResponse, <-chan error) {
	responseChan := make(chan *GetQueueAttributesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetQueueAttributes(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetQueueAttributesWithCallback invokes the mns_open.GetQueueAttributes API asynchronously
func (client *Client) GetQueueAttributesWithCallback(request *GetQueueAttributesRequest, callback func(response *GetQueueAttributesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetQueueAttributesResponse
		var err error
		defer close(result)
		response, err = client.GetQueueAttributes(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetQueueAttributesRequest is the request struct for api GetQueueAttributes
type GetQueueAttributesRequest struct {
	*requests.RpcRequest
	QueueName string `position:"Query" name:"QueueName"`
}

// GetQueueAttributesResponse is the response struct for api GetQueueAttributes
type GetQueueAttributesResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      int64  `json:"Code" xml:"Code"`
	Status    string `json:"Status" xml:"Status"`
	Message   string `json:"Message" xml:"Message"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateGetQueueAttributesRequest creates a request to invoke GetQueueAttributes API
func CreateGetQueueAttributesRequest() (request *GetQueueAttributesRequest) {
	request = &GetQueueAttributesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Mns-open", "2022-01-19", "GetQueueAttributes", "mns", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetQueueAttributesResponse creates a response to parse from GetQueueAttributes response
func CreateGetQueueAttributesResponse() (response *GetQueueAttributesResponse) {
	response = &GetQueueAttributesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
