package mpaas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateMcdpGroup invokes the mpaas.CreateMcdpGroup API synchronously
func (client *Client) CreateMcdpGroup(request *CreateMcdpGroupRequest) (response *CreateMcdpGroupResponse, err error) {
	response = CreateCreateMcdpGroupResponse()
	err = client.DoAction(request, response)
	return
}

// CreateMcdpGroupWithChan invokes the mpaas.CreateMcdpGroup API asynchronously
func (client *Client) CreateMcdpGroupWithChan(request *CreateMcdpGroupRequest) (<-chan *CreateMcdpGroupResponse, <-chan error) {
	responseChan := make(chan *CreateMcdpGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateMcdpGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateMcdpGroupWithCallback invokes the mpaas.CreateMcdpGroup API asynchronously
func (client *Client) CreateMcdpGroupWithCallback(request *CreateMcdpGroupRequest, callback func(response *CreateMcdpGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateMcdpGroupResponse
		var err error
		defer close(result)
		response, err = client.CreateMcdpGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateMcdpGroupRequest is the request struct for api CreateMcdpGroup
type CreateMcdpGroupRequest struct {
	*requests.RpcRequest
	MpaasMappcenterMcdpGroupCreateJsonStr string `position:"Body" name:"MpaasMappcenterMcdpGroupCreateJsonStr"`
	TenantId                              string `position:"Body" name:"TenantId"`
	AppId                                 string `position:"Body" name:"AppId"`
	WorkspaceId                           string `position:"Body" name:"WorkspaceId"`
}

// CreateMcdpGroupResponse is the response struct for api CreateMcdpGroup
type CreateMcdpGroupResponse struct {
	*responses.BaseResponse
	ResultMessage string                         `json:"ResultMessage" xml:"ResultMessage"`
	ResultCode    string                         `json:"ResultCode" xml:"ResultCode"`
	RequestId     string                         `json:"RequestId" xml:"RequestId"`
	ResultContent ResultContentInCreateMcdpGroup `json:"ResultContent" xml:"ResultContent"`
}

// CreateCreateMcdpGroupRequest creates a request to invoke CreateMcdpGroup API
func CreateCreateMcdpGroupRequest() (request *CreateMcdpGroupRequest) {
	request = &CreateMcdpGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mPaaS", "2020-10-28", "CreateMcdpGroup", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateMcdpGroupResponse creates a response to parse from CreateMcdpGroup response
func CreateCreateMcdpGroupResponse() (response *CreateMcdpGroupResponse) {
	response = &CreateMcdpGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
