package mpaas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetScanResultDetailById invokes the mpaas.GetScanResultDetailById API synchronously
func (client *Client) GetScanResultDetailById(request *GetScanResultDetailByIdRequest) (response *GetScanResultDetailByIdResponse, err error) {
	response = CreateGetScanResultDetailByIdResponse()
	err = client.DoAction(request, response)
	return
}

// GetScanResultDetailByIdWithChan invokes the mpaas.GetScanResultDetailById API asynchronously
func (client *Client) GetScanResultDetailByIdWithChan(request *GetScanResultDetailByIdRequest) (<-chan *GetScanResultDetailByIdResponse, <-chan error) {
	responseChan := make(chan *GetScanResultDetailByIdResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetScanResultDetailById(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetScanResultDetailByIdWithCallback invokes the mpaas.GetScanResultDetailById API asynchronously
func (client *Client) GetScanResultDetailByIdWithCallback(request *GetScanResultDetailByIdRequest, callback func(response *GetScanResultDetailByIdResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetScanResultDetailByIdResponse
		var err error
		defer close(result)
		response, err = client.GetScanResultDetailById(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetScanResultDetailByIdRequest is the request struct for api GetScanResultDetailById
type GetScanResultDetailByIdRequest struct {
	*requests.RpcRequest
	AppId       string           `position:"Body" name:"AppId"`
	TaskId      requests.Integer `position:"Body" name:"TaskId"`
	WorkspaceId string           `position:"Body" name:"WorkspaceId"`
}

// GetScanResultDetailByIdResponse is the response struct for api GetScanResultDetailById
type GetScanResultDetailByIdResponse struct {
	*responses.BaseResponse
}

// CreateGetScanResultDetailByIdRequest creates a request to invoke GetScanResultDetailById API
func CreateGetScanResultDetailByIdRequest() (request *GetScanResultDetailByIdRequest) {
	request = &GetScanResultDetailByIdRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mPaaS", "2020-10-28", "GetScanResultDetailById", "", "")
	request.Method = requests.POST
	return
}

// CreateGetScanResultDetailByIdResponse creates a response to parse from GetScanResultDetailById response
func CreateGetScanResultDetailByIdResponse() (response *GetScanResultDetailByIdResponse) {
	response = &GetScanResultDetailByIdResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
