package msccommonquery

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListMessages invokes the msccommonquery.ListMessages API synchronously
func (client *Client) ListMessages(request *ListMessagesRequest) (response *ListMessagesResponse, err error) {
	response = CreateListMessagesResponse()
	err = client.DoAction(request, response)
	return
}

// ListMessagesWithChan invokes the msccommonquery.ListMessages API asynchronously
func (client *Client) ListMessagesWithChan(request *ListMessagesRequest) (<-chan *ListMessagesResponse, <-chan error) {
	responseChan := make(chan *ListMessagesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListMessages(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListMessagesWithCallback invokes the msccommonquery.ListMessages API asynchronously
func (client *Client) ListMessagesWithCallback(request *ListMessagesRequest, callback func(response *ListMessagesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListMessagesResponse
		var err error
		defer close(result)
		response, err = client.ListMessages(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListMessagesRequest is the request struct for api ListMessages
type ListMessagesRequest struct {
	*requests.RpcRequest
	StartTimestamp requests.Integer `position:"Body" name:"StartTimestamp"`
	Locale         string           `position:"Query" name:"Locale"`
	EndTimestamp   requests.Integer `position:"Body" name:"EndTimestamp"`
	PageNo         requests.Integer `position:"Body" name:"PageNo"`
	ChannelType    string           `position:"Body" name:"ChannelType"`
	PageSize       requests.Integer `position:"Body" name:"PageSize"`
}

// ListMessagesResponse is the response struct for api ListMessages
type ListMessagesResponse struct {
	*responses.BaseResponse
	RequestId string    `json:"RequestId" xml:"RequestId"`
	Code      string    `json:"Code" xml:"Code"`
	Message   string    `json:"Message" xml:"Message"`
	Success   bool      `json:"Success" xml:"Success"`
	Total     int       `json:"Total" xml:"Total"`
	Data      []Message `json:"Data" xml:"Data"`
}

// CreateListMessagesRequest creates a request to invoke ListMessages API
func CreateListMessagesRequest() (request *ListMessagesRequest) {
	request = &ListMessagesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("MscCommonQuery", "2021-04-07", "ListMessages", "", "")
	request.Method = requests.POST
	return
}

// CreateListMessagesResponse creates a response to parse from ListMessages response
func CreateListMessagesResponse() (response *ListMessagesResponse) {
	response = &ListMessagesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
