package pvtz

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeZoneRecords invokes the pvtz.DescribeZoneRecords API synchronously
func (client *Client) DescribeZoneRecords(request *DescribeZoneRecordsRequest) (response *DescribeZoneRecordsResponse, err error) {
	response = CreateDescribeZoneRecordsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeZoneRecordsWithChan invokes the pvtz.DescribeZoneRecords API asynchronously
func (client *Client) DescribeZoneRecordsWithChan(request *DescribeZoneRecordsRequest) (<-chan *DescribeZoneRecordsResponse, <-chan error) {
	responseChan := make(chan *DescribeZoneRecordsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeZoneRecords(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeZoneRecordsWithCallback invokes the pvtz.DescribeZoneRecords API asynchronously
func (client *Client) DescribeZoneRecordsWithCallback(request *DescribeZoneRecordsRequest, callback func(response *DescribeZoneRecordsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeZoneRecordsResponse
		var err error
		defer close(result)
		response, err = client.DescribeZoneRecords(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeZoneRecordsRequest is the request struct for api DescribeZoneRecords
type DescribeZoneRecordsRequest struct {
	*requests.RpcRequest
	PageNumber   requests.Integer `position:"Query" name:"PageNumber"`
	PageSize     requests.Integer `position:"Query" name:"PageSize"`
	Tag          string           `position:"Query" name:"Tag"`
	Lang         string           `position:"Query" name:"Lang"`
	Keyword      string           `position:"Query" name:"Keyword"`
	Direction    string           `position:"Query" name:"Direction"`
	OrderBy      string           `position:"Query" name:"OrderBy"`
	UserClientIp string           `position:"Query" name:"UserClientIp"`
	ZoneId       string           `position:"Query" name:"ZoneId"`
	SearchMode   string           `position:"Query" name:"SearchMode"`
}

// DescribeZoneRecordsResponse is the response struct for api DescribeZoneRecords
type DescribeZoneRecordsResponse struct {
	*responses.BaseResponse
	PageSize   int     `json:"PageSize" xml:"PageSize"`
	RequestId  string  `json:"RequestId" xml:"RequestId"`
	PageNumber int     `json:"PageNumber" xml:"PageNumber"`
	TotalPages int     `json:"TotalPages" xml:"TotalPages"`
	TotalItems int     `json:"TotalItems" xml:"TotalItems"`
	Records    Records `json:"Records" xml:"Records"`
}

// CreateDescribeZoneRecordsRequest creates a request to invoke DescribeZoneRecords API
func CreateDescribeZoneRecordsRequest() (request *DescribeZoneRecordsRequest) {
	request = &DescribeZoneRecordsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("pvtz", "2018-01-01", "DescribeZoneRecords", "pvtz", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeZoneRecordsResponse creates a response to parse from DescribeZoneRecords response
func CreateDescribeZoneRecordsResponse() (response *DescribeZoneRecordsResponse) {
	response = &DescribeZoneRecordsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
