package resourcecenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateFilter invokes the resourcecenter.CreateFilter API synchronously
func (client *Client) CreateFilter(request *CreateFilterRequest) (response *CreateFilterResponse, err error) {
	response = CreateCreateFilterResponse()
	err = client.DoAction(request, response)
	return
}

// CreateFilterWithChan invokes the resourcecenter.CreateFilter API asynchronously
func (client *Client) CreateFilterWithChan(request *CreateFilterRequest) (<-chan *CreateFilterResponse, <-chan error) {
	responseChan := make(chan *CreateFilterResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateFilter(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateFilterWithCallback invokes the resourcecenter.CreateFilter API asynchronously
func (client *Client) CreateFilterWithCallback(request *CreateFilterRequest, callback func(response *CreateFilterResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateFilterResponse
		var err error
		defer close(result)
		response, err = client.CreateFilter(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateFilterRequest is the request struct for api CreateFilter
type CreateFilterRequest struct {
	*requests.RpcRequest
	FilterName          string `position:"Query" name:"FilterName"`
	FilterConfiguration string `position:"Query" name:"FilterConfiguration"`
}

// CreateFilterResponse is the response struct for api CreateFilter
type CreateFilterResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateFilterRequest creates a request to invoke CreateFilter API
func CreateCreateFilterRequest() (request *CreateFilterRequest) {
	request = &CreateFilterRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ResourceCenter", "2022-12-01", "CreateFilter", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateFilterResponse creates a response to parse from CreateFilter response
func CreateCreateFilterResponse() (response *CreateFilterResponse) {
	response = &CreateFilterResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
