package schedulerx2

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateRouteStrategy invokes the schedulerx2.CreateRouteStrategy API synchronously
func (client *Client) CreateRouteStrategy(request *CreateRouteStrategyRequest) (response *CreateRouteStrategyResponse, err error) {
	response = CreateCreateRouteStrategyResponse()
	err = client.DoAction(request, response)
	return
}

// CreateRouteStrategyWithChan invokes the schedulerx2.CreateRouteStrategy API asynchronously
func (client *Client) CreateRouteStrategyWithChan(request *CreateRouteStrategyRequest) (<-chan *CreateRouteStrategyResponse, <-chan error) {
	responseChan := make(chan *CreateRouteStrategyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateRouteStrategy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateRouteStrategyWithCallback invokes the schedulerx2.CreateRouteStrategy API asynchronously
func (client *Client) CreateRouteStrategyWithCallback(request *CreateRouteStrategyRequest, callback func(response *CreateRouteStrategyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateRouteStrategyResponse
		var err error
		defer close(result)
		response, err = client.CreateRouteStrategy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateRouteStrategyRequest is the request struct for api CreateRouteStrategy
type CreateRouteStrategyRequest struct {
	*requests.RpcRequest
	Type            requests.Integer `position:"Query" name:"Type"`
	JobId           requests.Integer `position:"Query" name:"JobId"`
	GroupId         string           `position:"Query" name:"GroupId"`
	StrategyContent string           `position:"Query" name:"StrategyContent"`
	Name            string           `position:"Query" name:"Name"`
	Namespace       string           `position:"Query" name:"Namespace"`
	Status          requests.Integer `position:"Query" name:"Status"`
}

// CreateRouteStrategyResponse is the response struct for api CreateRouteStrategy
type CreateRouteStrategyResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateCreateRouteStrategyRequest creates a request to invoke CreateRouteStrategy API
func CreateCreateRouteStrategyRequest() (request *CreateRouteStrategyRequest) {
	request = &CreateRouteStrategyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("schedulerx2", "2019-04-30", "CreateRouteStrategy", "schedulerx2", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateRouteStrategyResponse creates a response to parse from CreateRouteStrategy response
func CreateCreateRouteStrategyResponse() (response *CreateRouteStrategyResponse) {
	response = &CreateRouteStrategyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
