package schedulerx3

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// OperateDisableJobs invokes the schedulerx3.OperateDisableJobs API synchronously
func (client *Client) OperateDisableJobs(request *OperateDisableJobsRequest) (response *OperateDisableJobsResponse, err error) {
	response = CreateOperateDisableJobsResponse()
	err = client.DoAction(request, response)
	return
}

// OperateDisableJobsWithChan invokes the schedulerx3.OperateDisableJobs API asynchronously
func (client *Client) OperateDisableJobsWithChan(request *OperateDisableJobsRequest) (<-chan *OperateDisableJobsResponse, <-chan error) {
	responseChan := make(chan *OperateDisableJobsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.OperateDisableJobs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// OperateDisableJobsWithCallback invokes the schedulerx3.OperateDisableJobs API asynchronously
func (client *Client) OperateDisableJobsWithCallback(request *OperateDisableJobsRequest, callback func(response *OperateDisableJobsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *OperateDisableJobsResponse
		var err error
		defer close(result)
		response, err = client.OperateDisableJobs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// OperateDisableJobsRequest is the request struct for api OperateDisableJobs
type OperateDisableJobsRequest struct {
	*requests.RpcRequest
	MseSessionId string    `position:"Query" name:"MseSessionId"`
	ClusterId    string    `position:"Body" name:"ClusterId"`
	AppName      string    `position:"Body" name:"AppName"`
	JobIds       *[]string `position:"Body" name:"JobIds"  type:"Json"`
}

// OperateDisableJobsResponse is the response struct for api OperateDisableJobs
type OperateDisableJobsResponse struct {
	*responses.BaseResponse
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateOperateDisableJobsRequest creates a request to invoke OperateDisableJobs API
func CreateOperateDisableJobsRequest() (request *OperateDisableJobsRequest) {
	request = &OperateDisableJobsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("SchedulerX3", "2024-06-24", "OperateDisableJobs", "", "")
	request.Method = requests.POST
	return
}

// CreateOperateDisableJobsResponse creates a response to parse from OperateDisableJobs response
func CreateOperateDisableJobsResponse() (response *OperateDisableJobsResponse) {
	response = &OperateDisableJobsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
