package sddp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeCategoryTemplateList invokes the sddp.DescribeCategoryTemplateList API synchronously
func (client *Client) DescribeCategoryTemplateList(request *DescribeCategoryTemplateListRequest) (response *DescribeCategoryTemplateListResponse, err error) {
	response = CreateDescribeCategoryTemplateListResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeCategoryTemplateListWithChan invokes the sddp.DescribeCategoryTemplateList API asynchronously
func (client *Client) DescribeCategoryTemplateListWithChan(request *DescribeCategoryTemplateListRequest) (<-chan *DescribeCategoryTemplateListResponse, <-chan error) {
	responseChan := make(chan *DescribeCategoryTemplateListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeCategoryTemplateList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeCategoryTemplateListWithCallback invokes the sddp.DescribeCategoryTemplateList API asynchronously
func (client *Client) DescribeCategoryTemplateListWithCallback(request *DescribeCategoryTemplateListRequest, callback func(response *DescribeCategoryTemplateListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeCategoryTemplateListResponse
		var err error
		defer close(result)
		response, err = client.DescribeCategoryTemplateList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeCategoryTemplateListRequest is the request struct for api DescribeCategoryTemplateList
type DescribeCategoryTemplateListRequest struct {
	*requests.RpcRequest
	FeatureType   requests.Integer `position:"Query" name:"FeatureType"`
	CurrentPage   requests.Integer `position:"Query" name:"CurrentPage"`
	SourceIp      string           `position:"Query" name:"SourceIp"`
	PageSize      requests.Integer `position:"Query" name:"PageSize"`
	UsageScenario requests.Integer `position:"Query" name:"UsageScenario"`
	Lang          string           `position:"Query" name:"Lang"`
}

// DescribeCategoryTemplateListResponse is the response struct for api DescribeCategoryTemplateList
type DescribeCategoryTemplateListResponse struct {
	*responses.BaseResponse
	CurrentPage int        `json:"CurrentPage" xml:"CurrentPage"`
	RequestId   string     `json:"RequestId" xml:"RequestId"`
	PageSize    int        `json:"PageSize" xml:"PageSize"`
	TotalCount  int        `json:"TotalCount" xml:"TotalCount"`
	Items       []Template `json:"Items" xml:"Items"`
}

// CreateDescribeCategoryTemplateListRequest creates a request to invoke DescribeCategoryTemplateList API
func CreateDescribeCategoryTemplateListRequest() (request *DescribeCategoryTemplateListRequest) {
	request = &DescribeCategoryTemplateListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sddp", "2019-01-03", "DescribeCategoryTemplateList", "sddp", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeCategoryTemplateListResponse creates a response to parse from DescribeCategoryTemplateList response
func CreateDescribeCategoryTemplateListResponse() (response *DescribeCategoryTemplateListResponse) {
	response = &DescribeCategoryTemplateListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
