package swas_open

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// StopDatabaseInstance invokes the swas_open.StopDatabaseInstance API synchronously
func (client *Client) StopDatabaseInstance(request *StopDatabaseInstanceRequest) (response *StopDatabaseInstanceResponse, err error) {
	response = CreateStopDatabaseInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// StopDatabaseInstanceWithChan invokes the swas_open.StopDatabaseInstance API asynchronously
func (client *Client) StopDatabaseInstanceWithChan(request *StopDatabaseInstanceRequest) (<-chan *StopDatabaseInstanceResponse, <-chan error) {
	responseChan := make(chan *StopDatabaseInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.StopDatabaseInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// StopDatabaseInstanceWithCallback invokes the swas_open.StopDatabaseInstance API asynchronously
func (client *Client) StopDatabaseInstanceWithCallback(request *StopDatabaseInstanceRequest, callback func(response *StopDatabaseInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *StopDatabaseInstanceResponse
		var err error
		defer close(result)
		response, err = client.StopDatabaseInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// StopDatabaseInstanceRequest is the request struct for api StopDatabaseInstance
type StopDatabaseInstanceRequest struct {
	*requests.RpcRequest
	ClientToken        string `position:"Query" name:"ClientToken"`
	DatabaseInstanceId string `position:"Query" name:"DatabaseInstanceId"`
}

// StopDatabaseInstanceResponse is the response struct for api StopDatabaseInstance
type StopDatabaseInstanceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateStopDatabaseInstanceRequest creates a request to invoke StopDatabaseInstance API
func CreateStopDatabaseInstanceRequest() (request *StopDatabaseInstanceRequest) {
	request = &StopDatabaseInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("SWAS-OPEN", "2020-06-01", "StopDatabaseInstance", "SWAS-OPEN", "openAPI")
	request.Method = requests.POST
	return
}

// CreateStopDatabaseInstanceResponse creates a response to parse from StopDatabaseInstance response
func CreateStopDatabaseInstanceResponse() (response *StopDatabaseInstanceResponse) {
	response = &StopDatabaseInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
