package vod

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListJobInfo invokes the vod.ListJobInfo API synchronously
func (client *Client) ListJobInfo(request *ListJobInfoRequest) (response *ListJobInfoResponse, err error) {
	response = CreateListJobInfoResponse()
	err = client.DoAction(request, response)
	return
}

// ListJobInfoWithChan invokes the vod.ListJobInfo API asynchronously
func (client *Client) ListJobInfoWithChan(request *ListJobInfoRequest) (<-chan *ListJobInfoResponse, <-chan error) {
	responseChan := make(chan *ListJobInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListJobInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListJobInfoWithCallback invokes the vod.ListJobInfo API asynchronously
func (client *Client) ListJobInfoWithCallback(request *ListJobInfoRequest, callback func(response *ListJobInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListJobInfoResponse
		var err error
		defer close(result)
		response, err = client.ListJobInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListJobInfoRequest is the request struct for api ListJobInfo
type ListJobInfoRequest struct {
	*requests.RpcRequest
	MediaId string `position:"Query" name:"MediaId"`
	JobType string `position:"Query" name:"JobType"`
}

// ListJobInfoResponse is the response struct for api ListJobInfo
type ListJobInfoResponse struct {
	*responses.BaseResponse
	RequestId   string      `json:"RequestId" xml:"RequestId"`
	MediaId     string      `json:"MediaId" xml:"MediaId"`
	JobType     string      `json:"JobType" xml:"JobType"`
	JobInfoList []JobInfoDO `json:"JobInfoList" xml:"JobInfoList"`
}

// CreateListJobInfoRequest creates a request to invoke ListJobInfo API
func CreateListJobInfoRequest() (request *ListJobInfoRequest) {
	request = &ListJobInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vod", "2017-03-21", "ListJobInfo", "vod", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListJobInfoResponse creates a response to parse from ListJobInfo response
func CreateListJobInfoResponse() (response *ListJobInfoResponse) {
	response = &ListJobInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
