package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetVpnGatewayDiagnoseResult invokes the vpc.GetVpnGatewayDiagnoseResult API synchronously
func (client *Client) GetVpnGatewayDiagnoseResult(request *GetVpnGatewayDiagnoseResultRequest) (response *GetVpnGatewayDiagnoseResultResponse, err error) {
	response = CreateGetVpnGatewayDiagnoseResultResponse()
	err = client.DoAction(request, response)
	return
}

// GetVpnGatewayDiagnoseResultWithChan invokes the vpc.GetVpnGatewayDiagnoseResult API asynchronously
func (client *Client) GetVpnGatewayDiagnoseResultWithChan(request *GetVpnGatewayDiagnoseResultRequest) (<-chan *GetVpnGatewayDiagnoseResultResponse, <-chan error) {
	responseChan := make(chan *GetVpnGatewayDiagnoseResultResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetVpnGatewayDiagnoseResult(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetVpnGatewayDiagnoseResultWithCallback invokes the vpc.GetVpnGatewayDiagnoseResult API asynchronously
func (client *Client) GetVpnGatewayDiagnoseResultWithCallback(request *GetVpnGatewayDiagnoseResultRequest, callback func(response *GetVpnGatewayDiagnoseResultResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetVpnGatewayDiagnoseResultResponse
		var err error
		defer close(result)
		response, err = client.GetVpnGatewayDiagnoseResult(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetVpnGatewayDiagnoseResultRequest is the request struct for api GetVpnGatewayDiagnoseResult
type GetVpnGatewayDiagnoseResultRequest struct {
	*requests.RpcRequest
	ClientToken  string `position:"Query" name:"ClientToken"`
	DiagnoseId   string `position:"Query" name:"DiagnoseId"`
	VpnGatewayId string `position:"Query" name:"VpnGatewayId"`
}

// GetVpnGatewayDiagnoseResultResponse is the response struct for api GetVpnGatewayDiagnoseResult
type GetVpnGatewayDiagnoseResultResponse struct {
	*responses.BaseResponse
	BeginTime          string               `json:"BeginTime" xml:"BeginTime"`
	DiagnoseId         string               `json:"DiagnoseId" xml:"DiagnoseId"`
	FinishTime         string               `json:"FinishTime" xml:"FinishTime"`
	FinishedCount      int                  `json:"FinishedCount" xml:"FinishedCount"`
	RequestId          string               `json:"RequestId" xml:"RequestId"`
	ResourceInstanceId string               `json:"ResourceInstanceId" xml:"ResourceInstanceId"`
	ResourceType       string               `json:"ResourceType" xml:"ResourceType"`
	TotalCount         int                  `json:"TotalCount" xml:"TotalCount"`
	VpnGatewayId       string               `json:"VpnGatewayId" xml:"VpnGatewayId"`
	DiagnoseResult     []DiagnoseResultItem `json:"DiagnoseResult" xml:"DiagnoseResult"`
}

// CreateGetVpnGatewayDiagnoseResultRequest creates a request to invoke GetVpnGatewayDiagnoseResult API
func CreateGetVpnGatewayDiagnoseResultRequest() (request *GetVpnGatewayDiagnoseResultRequest) {
	request = &GetVpnGatewayDiagnoseResultRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "GetVpnGatewayDiagnoseResult", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetVpnGatewayDiagnoseResultResponse creates a response to parse from GetVpnGatewayDiagnoseResult response
func CreateGetVpnGatewayDiagnoseResultResponse() (response *GetVpnGatewayDiagnoseResultResponse) {
	response = &GetVpnGatewayDiagnoseResultResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
