package adb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeConnectionCountRecords invokes the adb.DescribeConnectionCountRecords API synchronously
func (client *Client) DescribeConnectionCountRecords(request *DescribeConnectionCountRecordsRequest) (response *DescribeConnectionCountRecordsResponse, err error) {
	response = CreateDescribeConnectionCountRecordsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeConnectionCountRecordsWithChan invokes the adb.DescribeConnectionCountRecords API asynchronously
func (client *Client) DescribeConnectionCountRecordsWithChan(request *DescribeConnectionCountRecordsRequest) (<-chan *DescribeConnectionCountRecordsResponse, <-chan error) {
	responseChan := make(chan *DescribeConnectionCountRecordsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeConnectionCountRecords(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeConnectionCountRecordsWithCallback invokes the adb.DescribeConnectionCountRecords API asynchronously
func (client *Client) DescribeConnectionCountRecordsWithCallback(request *DescribeConnectionCountRecordsRequest, callback func(response *DescribeConnectionCountRecordsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeConnectionCountRecordsResponse
		var err error
		defer close(result)
		response, err = client.DescribeConnectionCountRecords(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeConnectionCountRecordsRequest is the request struct for api DescribeConnectionCountRecords
type DescribeConnectionCountRecordsRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	DBClusterId          string           `position:"Query" name:"DBClusterId"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeConnectionCountRecordsResponse is the response struct for api DescribeConnectionCountRecords
type DescribeConnectionCountRecordsResponse struct {
	*responses.BaseResponse
	TotalCount      string      `json:"TotalCount" xml:"TotalCount"`
	RequestId       string      `json:"RequestId" xml:"RequestId"`
	DBClusterId     string      `json:"DBClusterId" xml:"DBClusterId"`
	AccessIpRecords []AccessIps `json:"AccessIpRecords" xml:"AccessIpRecords"`
	UserRecords     []Users     `json:"UserRecords" xml:"UserRecords"`
}

// CreateDescribeConnectionCountRecordsRequest creates a request to invoke DescribeConnectionCountRecords API
func CreateDescribeConnectionCountRecordsRequest() (request *DescribeConnectionCountRecordsRequest) {
	request = &DescribeConnectionCountRecordsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("adb", "2019-03-15", "DescribeConnectionCountRecords", "ads", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeConnectionCountRecordsResponse creates a response to parse from DescribeConnectionCountRecords response
func CreateDescribeConnectionCountRecordsResponse() (response *DescribeConnectionCountRecordsResponse) {
	response = &DescribeConnectionCountRecordsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
