package aegis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeVulBatch invokes the aegis.DescribeVulBatch API synchronously
// api document: https://help.aliyun.com/api/aegis/describevulbatch.html
func (client *Client) DescribeVulBatch(request *DescribeVulBatchRequest) (response *DescribeVulBatchResponse, err error) {
	response = CreateDescribeVulBatchResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeVulBatchWithChan invokes the aegis.DescribeVulBatch API asynchronously
// api document: https://help.aliyun.com/api/aegis/describevulbatch.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeVulBatchWithChan(request *DescribeVulBatchRequest) (<-chan *DescribeVulBatchResponse, <-chan error) {
	responseChan := make(chan *DescribeVulBatchResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeVulBatch(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeVulBatchWithCallback invokes the aegis.DescribeVulBatch API asynchronously
// api document: https://help.aliyun.com/api/aegis/describevulbatch.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeVulBatchWithCallback(request *DescribeVulBatchRequest, callback func(response *DescribeVulBatchResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeVulBatchResponse
		var err error
		defer close(result)
		response, err = client.DescribeVulBatch(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeVulBatchRequest is the request struct for api DescribeVulBatch
type DescribeVulBatchRequest struct {
	*requests.RpcRequest
	SourceIp string `position:"Query" name:"SourceIp"`
	Resource string `position:"Query" name:"Resource"`
}

// DescribeVulBatchResponse is the response struct for api DescribeVulBatch
type DescribeVulBatchResponse struct {
	*responses.BaseResponse
	RequestId  string   `json:"RequestId" xml:"RequestId"`
	BatchNames []string `json:"BatchNames" xml:"BatchNames"`
}

// CreateDescribeVulBatchRequest creates a request to invoke DescribeVulBatch API
func CreateDescribeVulBatchRequest() (request *DescribeVulBatchRequest) {
	request = &DescribeVulBatchRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("aegis", "2016-11-11", "DescribeVulBatch", "vipaegis", "openAPI")
	return
}

// CreateDescribeVulBatchResponse creates a response to parse from DescribeVulBatch response
func CreateDescribeVulBatchResponse() (response *DescribeVulBatchResponse) {
	response = &DescribeVulBatchResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
