package aegis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetEntityList invokes the aegis.GetEntityList API synchronously
// api document: https://help.aliyun.com/api/aegis/getentitylist.html
func (client *Client) GetEntityList(request *GetEntityListRequest) (response *GetEntityListResponse, err error) {
	response = CreateGetEntityListResponse()
	err = client.DoAction(request, response)
	return
}

// GetEntityListWithChan invokes the aegis.GetEntityList API asynchronously
// api document: https://help.aliyun.com/api/aegis/getentitylist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetEntityListWithChan(request *GetEntityListRequest) (<-chan *GetEntityListResponse, <-chan error) {
	responseChan := make(chan *GetEntityListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetEntityList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetEntityListWithCallback invokes the aegis.GetEntityList API asynchronously
// api document: https://help.aliyun.com/api/aegis/getentitylist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetEntityListWithCallback(request *GetEntityListRequest, callback func(response *GetEntityListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetEntityListResponse
		var err error
		defer close(result)
		response, err = client.GetEntityList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetEntityListRequest is the request struct for api GetEntityList
type GetEntityListRequest struct {
	*requests.RpcRequest
	GroupId     requests.Integer `position:"Query" name:"GroupId"`
	PageSize    requests.Integer `position:"Query" name:"PageSize"`
	Remark      string           `position:"Query" name:"Remark"`
	EventType   string           `position:"Query" name:"EventType"`
	CurrentPage requests.Integer `position:"Query" name:"CurrentPage"`
	RegionNo    string           `position:"Query" name:"RegionNo"`
}

// GetEntityListResponse is the response struct for api GetEntityList
type GetEntityListResponse struct {
	*responses.BaseResponse
	RequestId string `json:"requestId" xml:"requestId"`
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
	Message   string `json:"Message" xml:"Message"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateGetEntityListRequest creates a request to invoke GetEntityList API
func CreateGetEntityListRequest() (request *GetEntityListRequest) {
	request = &GetEntityListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("aegis", "2016-11-11", "GetEntityList", "vipaegis", "openAPI")
	return
}

// CreateGetEntityListResponse creates a response to parse from GetEntityList response
func CreateGetEntityListResponse() (response *GetEntityListResponse) {
	response = &GetEntityListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
