package ahas_openapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateHotParamRule invokes the ahas_openapi.CreateHotParamRule API synchronously
func (client *Client) CreateHotParamRule(request *CreateHotParamRuleRequest) (response *CreateHotParamRuleResponse, err error) {
	response = CreateCreateHotParamRuleResponse()
	err = client.DoAction(request, response)
	return
}

// CreateHotParamRuleWithChan invokes the ahas_openapi.CreateHotParamRule API asynchronously
func (client *Client) CreateHotParamRuleWithChan(request *CreateHotParamRuleRequest) (<-chan *CreateHotParamRuleResponse, <-chan error) {
	responseChan := make(chan *CreateHotParamRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateHotParamRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateHotParamRuleWithCallback invokes the ahas_openapi.CreateHotParamRule API asynchronously
func (client *Client) CreateHotParamRuleWithCallback(request *CreateHotParamRuleRequest, callback func(response *CreateHotParamRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateHotParamRuleResponse
		var err error
		defer close(result)
		response, err = client.CreateHotParamRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateHotParamRuleRequest is the request struct for api CreateHotParamRule
type CreateHotParamRuleRequest struct {
	*requests.RpcRequest
	MetricType        requests.Integer `position:"Query" name:"MetricType"`
	ParamIdx          requests.Integer `position:"Query" name:"ParamIdx"`
	ControlBehavior   requests.Integer `position:"Query" name:"ControlBehavior"`
	Resource          string           `position:"Query" name:"Resource"`
	Threshold         requests.Float   `position:"Query" name:"Threshold"`
	AhasRegionId      string           `position:"Query" name:"AhasRegionId"`
	AppName           string           `position:"Query" name:"AppName"`
	Enable            requests.Boolean `position:"Query" name:"Enable"`
	Namespace         string           `position:"Query" name:"Namespace"`
	MaxQueueingTimeMs requests.Integer `position:"Query" name:"MaxQueueingTimeMs"`
	StatDurationSec   requests.Integer `position:"Query" name:"StatDurationSec"`
	BurstCount        requests.Integer `position:"Query" name:"BurstCount"`
}

// CreateHotParamRuleResponse is the response struct for api CreateHotParamRule
type CreateHotParamRuleResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateCreateHotParamRuleRequest creates a request to invoke CreateHotParamRule API
func CreateCreateHotParamRuleRequest() (request *CreateHotParamRuleRequest) {
	request = &CreateHotParamRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ahas-openapi", "2019-09-01", "CreateHotParamRule", "ahas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateHotParamRuleResponse creates a response to parse from CreateHotParamRule response
func CreateCreateHotParamRuleResponse() (response *CreateHotParamRuleResponse) {
	response = &CreateHotParamRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
