package alidns

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteDomainRecord invokes the alidns.DeleteDomainRecord API synchronously
func (client *Client) DeleteDomainRecord(request *DeleteDomainRecordRequest) (response *DeleteDomainRecordResponse, err error) {
	response = CreateDeleteDomainRecordResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteDomainRecordWithChan invokes the alidns.DeleteDomainRecord API asynchronously
func (client *Client) DeleteDomainRecordWithChan(request *DeleteDomainRecordRequest) (<-chan *DeleteDomainRecordResponse, <-chan error) {
	responseChan := make(chan *DeleteDomainRecordResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteDomainRecord(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteDomainRecordWithCallback invokes the alidns.DeleteDomainRecord API asynchronously
func (client *Client) DeleteDomainRecordWithCallback(request *DeleteDomainRecordRequest, callback func(response *DeleteDomainRecordResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteDomainRecordResponse
		var err error
		defer close(result)
		response, err = client.DeleteDomainRecord(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteDomainRecordRequest is the request struct for api DeleteDomainRecord
type DeleteDomainRecordRequest struct {
	*requests.RpcRequest
	RecordId     string `position:"Query" name:"RecordId"`
	UserClientIp string `position:"Query" name:"UserClientIp"`
	Lang         string `position:"Query" name:"Lang"`
}

// DeleteDomainRecordResponse is the response struct for api DeleteDomainRecord
type DeleteDomainRecordResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	RecordId  string `json:"RecordId" xml:"RecordId"`
}

// CreateDeleteDomainRecordRequest creates a request to invoke DeleteDomainRecord API
func CreateDeleteDomainRecordRequest() (request *DeleteDomainRecordRequest) {
	request = &DeleteDomainRecordRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Alidns", "2015-01-09", "DeleteDomainRecord", "alidns", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteDomainRecordResponse creates a response to parse from DeleteDomainRecord response
func CreateDeleteDomainRecordResponse() (response *DeleteDomainRecordResponse) {
	response = &DeleteDomainRecordResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
