package amqp_open

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListVirtualHosts invokes the amqp_open.ListVirtualHosts API synchronously
func (client *Client) ListVirtualHosts(request *ListVirtualHostsRequest) (response *ListVirtualHostsResponse, err error) {
	response = CreateListVirtualHostsResponse()
	err = client.DoAction(request, response)
	return
}

// ListVirtualHostsWithChan invokes the amqp_open.ListVirtualHosts API asynchronously
func (client *Client) ListVirtualHostsWithChan(request *ListVirtualHostsRequest) (<-chan *ListVirtualHostsResponse, <-chan error) {
	responseChan := make(chan *ListVirtualHostsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListVirtualHosts(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListVirtualHostsWithCallback invokes the amqp_open.ListVirtualHosts API asynchronously
func (client *Client) ListVirtualHostsWithCallback(request *ListVirtualHostsRequest, callback func(response *ListVirtualHostsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListVirtualHostsResponse
		var err error
		defer close(result)
		response, err = client.ListVirtualHosts(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListVirtualHostsRequest is the request struct for api ListVirtualHosts
type ListVirtualHostsRequest struct {
	*requests.RpcRequest
	InstanceId string           `position:"Query" name:"InstanceId"`
	NextToken  string           `position:"Query" name:"NextToken"`
	MaxResults requests.Integer `position:"Query" name:"MaxResults"`
}

// ListVirtualHostsResponse is the response struct for api ListVirtualHosts
type ListVirtualHostsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateListVirtualHostsRequest creates a request to invoke ListVirtualHosts API
func CreateListVirtualHostsRequest() (request *ListVirtualHostsRequest) {
	request = &ListVirtualHostsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("amqp-open", "2019-12-12", "ListVirtualHosts", "onsproxy", "openAPI")
	request.Method = requests.GET
	return
}

// CreateListVirtualHostsResponse creates a response to parse from ListVirtualHosts response
func CreateListVirtualHostsResponse() (response *ListVirtualHostsResponse) {
	response = &ListVirtualHostsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
