package appstream_center

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetConnectionTicket invokes the appstream_center.GetConnectionTicket API synchronously
func (client *Client) GetConnectionTicket(request *GetConnectionTicketRequest) (response *GetConnectionTicketResponse, err error) {
	response = CreateGetConnectionTicketResponse()
	err = client.DoAction(request, response)
	return
}

// GetConnectionTicketWithChan invokes the appstream_center.GetConnectionTicket API asynchronously
func (client *Client) GetConnectionTicketWithChan(request *GetConnectionTicketRequest) (<-chan *GetConnectionTicketResponse, <-chan error) {
	responseChan := make(chan *GetConnectionTicketResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetConnectionTicket(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetConnectionTicketWithCallback invokes the appstream_center.GetConnectionTicket API asynchronously
func (client *Client) GetConnectionTicketWithCallback(request *GetConnectionTicketRequest, callback func(response *GetConnectionTicketResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetConnectionTicketResponse
		var err error
		defer close(result)
		response, err = client.GetConnectionTicket(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetConnectionTicketRequest is the request struct for api GetConnectionTicket
type GetConnectionTicketRequest struct {
	*requests.RpcRequest
	BizRegionId            string                          `position:"Body" name:"BizRegionId"`
	AppStartParam          string                          `position:"Body" name:"AppStartParam"`
	ProductType            string                          `position:"Body" name:"ProductType"`
	EndUserId              string                          `position:"Body" name:"EndUserId"`
	FileInfos              *[]GetConnectionTicketFileInfos `position:"Body" name:"FileInfos"  type:"Repeated"`
	TaskId                 string                          `position:"Body" name:"TaskId"`
	AppVersion             string                          `position:"Body" name:"AppVersion"`
	AppInstanceGroupIdList *[]string                       `position:"Body" name:"AppInstanceGroupIdList"  type:"Repeated"`
	AppId                  string                          `position:"Body" name:"AppId"`
	AppInstanceId          string                          `position:"Body" name:"AppInstanceId"`
}

// GetConnectionTicketFileInfos is a repeated param struct in GetConnectionTicketRequest
type GetConnectionTicketFileInfos struct {
	FileRegion string `name:"FileRegion"`
	DriveId    string `name:"DriveId"`
	FileName   string `name:"FileName"`
	FilePath   string `name:"FilePath"`
	DriveType  string `name:"DriveType"`
	FileId     string `name:"FileId"`
}

// GetConnectionTicketResponse is the response struct for api GetConnectionTicket
type GetConnectionTicketResponse struct {
	*responses.BaseResponse
	RequestId          string `json:"RequestId" xml:"RequestId"`
	TaskStatus         string `json:"TaskStatus" xml:"TaskStatus"`
	TaskId             string `json:"TaskId" xml:"TaskId"`
	BizRegionId        string `json:"BizRegionId" xml:"BizRegionId"`
	Ticket             string `json:"Ticket" xml:"Ticket"`
	AppInstanceGroupId string `json:"AppInstanceGroupId" xml:"AppInstanceGroupId"`
	AppInstanceId      string `json:"AppInstanceId" xml:"AppInstanceId"`
	OsType             string `json:"OsType" xml:"OsType"`
}

// CreateGetConnectionTicketRequest creates a request to invoke GetConnectionTicket API
func CreateGetConnectionTicketRequest() (request *GetConnectionTicketRequest) {
	request = &GetConnectionTicketRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("appstream-center", "2021-09-01", "GetConnectionTicket", "", "")
	request.Method = requests.POST
	return
}

// CreateGetConnectionTicketResponse creates a response to parse from GetConnectionTicket response
func CreateGetConnectionTicketResponse() (response *GetConnectionTicketResponse) {
	response = &GetConnectionTicketResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
