package arms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListPrometheusRemoteWrites invokes the arms.ListPrometheusRemoteWrites API synchronously
func (client *Client) ListPrometheusRemoteWrites(request *ListPrometheusRemoteWritesRequest) (response *ListPrometheusRemoteWritesResponse, err error) {
	response = CreateListPrometheusRemoteWritesResponse()
	err = client.DoAction(request, response)
	return
}

// ListPrometheusRemoteWritesWithChan invokes the arms.ListPrometheusRemoteWrites API asynchronously
func (client *Client) ListPrometheusRemoteWritesWithChan(request *ListPrometheusRemoteWritesRequest) (<-chan *ListPrometheusRemoteWritesResponse, <-chan error) {
	responseChan := make(chan *ListPrometheusRemoteWritesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListPrometheusRemoteWrites(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListPrometheusRemoteWritesWithCallback invokes the arms.ListPrometheusRemoteWrites API asynchronously
func (client *Client) ListPrometheusRemoteWritesWithCallback(request *ListPrometheusRemoteWritesRequest, callback func(response *ListPrometheusRemoteWritesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListPrometheusRemoteWritesResponse
		var err error
		defer close(result)
		response, err = client.ListPrometheusRemoteWrites(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListPrometheusRemoteWritesRequest is the request struct for api ListPrometheusRemoteWrites
type ListPrometheusRemoteWritesRequest struct {
	*requests.RpcRequest
	ClusterId string `position:"Query" name:"ClusterId"`
}

// ListPrometheusRemoteWritesResponse is the response struct for api ListPrometheusRemoteWrites
type ListPrometheusRemoteWritesResponse struct {
	*responses.BaseResponse
	RequestId string        `json:"RequestId" xml:"RequestId"`
	Success   bool          `json:"Success" xml:"Success"`
	Message   string        `json:"Message" xml:"Message"`
	Code      int           `json:"Code" xml:"Code"`
	Data      []RemoteWrite `json:"Data" xml:"Data"`
}

// CreateListPrometheusRemoteWritesRequest creates a request to invoke ListPrometheusRemoteWrites API
func CreateListPrometheusRemoteWritesRequest() (request *ListPrometheusRemoteWritesRequest) {
	request = &ListPrometheusRemoteWritesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ARMS", "2019-08-08", "ListPrometheusRemoteWrites", "arms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListPrometheusRemoteWritesResponse creates a response to parse from ListPrometheusRemoteWrites response
func CreateListPrometheusRemoteWritesResponse() (response *ListPrometheusRemoteWritesResponse) {
	response = &ListPrometheusRemoteWritesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
