package arms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdatePrometheusRemoteWrite invokes the arms.UpdatePrometheusRemoteWrite API synchronously
func (client *Client) UpdatePrometheusRemoteWrite(request *UpdatePrometheusRemoteWriteRequest) (response *UpdatePrometheusRemoteWriteResponse, err error) {
	response = CreateUpdatePrometheusRemoteWriteResponse()
	err = client.DoAction(request, response)
	return
}

// UpdatePrometheusRemoteWriteWithChan invokes the arms.UpdatePrometheusRemoteWrite API asynchronously
func (client *Client) UpdatePrometheusRemoteWriteWithChan(request *UpdatePrometheusRemoteWriteRequest) (<-chan *UpdatePrometheusRemoteWriteResponse, <-chan error) {
	responseChan := make(chan *UpdatePrometheusRemoteWriteResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdatePrometheusRemoteWrite(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdatePrometheusRemoteWriteWithCallback invokes the arms.UpdatePrometheusRemoteWrite API asynchronously
func (client *Client) UpdatePrometheusRemoteWriteWithCallback(request *UpdatePrometheusRemoteWriteRequest, callback func(response *UpdatePrometheusRemoteWriteResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdatePrometheusRemoteWriteResponse
		var err error
		defer close(result)
		response, err = client.UpdatePrometheusRemoteWrite(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdatePrometheusRemoteWriteRequest is the request struct for api UpdatePrometheusRemoteWrite
type UpdatePrometheusRemoteWriteRequest struct {
	*requests.RpcRequest
	ClusterId       string `position:"Query" name:"ClusterId"`
	RemoteWriteName string `position:"Query" name:"RemoteWriteName"`
	RemoteWriteYaml string `position:"Body" name:"RemoteWriteYaml"`
}

// UpdatePrometheusRemoteWriteResponse is the response struct for api UpdatePrometheusRemoteWrite
type UpdatePrometheusRemoteWriteResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
	Success   bool   `json:"Success" xml:"Success"`
	Message   string `json:"Message" xml:"Message"`
	Code      int    `json:"Code" xml:"Code"`
}

// CreateUpdatePrometheusRemoteWriteRequest creates a request to invoke UpdatePrometheusRemoteWrite API
func CreateUpdatePrometheusRemoteWriteRequest() (request *UpdatePrometheusRemoteWriteRequest) {
	request = &UpdatePrometheusRemoteWriteRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ARMS", "2019-08-08", "UpdatePrometheusRemoteWrite", "arms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdatePrometheusRemoteWriteResponse creates a response to parse from UpdatePrometheusRemoteWrite response
func CreateUpdatePrometheusRemoteWriteResponse() (response *UpdatePrometheusRemoteWriteResponse) {
	response = &UpdatePrometheusRemoteWriteResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
