package cas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CancelCertificateForPackageRequest invokes the cas.CancelCertificateForPackageRequest API synchronously
func (client *Client) CancelCertificateForPackageRequest(request *CancelCertificateForPackageRequestRequest) (response *CancelCertificateForPackageRequestResponse, err error) {
	response = CreateCancelCertificateForPackageRequestResponse()
	err = client.DoAction(request, response)
	return
}

// CancelCertificateForPackageRequestWithChan invokes the cas.CancelCertificateForPackageRequest API asynchronously
func (client *Client) CancelCertificateForPackageRequestWithChan(request *CancelCertificateForPackageRequestRequest) (<-chan *CancelCertificateForPackageRequestResponse, <-chan error) {
	responseChan := make(chan *CancelCertificateForPackageRequestResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CancelCertificateForPackageRequest(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CancelCertificateForPackageRequestWithCallback invokes the cas.CancelCertificateForPackageRequest API asynchronously
func (client *Client) CancelCertificateForPackageRequestWithCallback(request *CancelCertificateForPackageRequestRequest, callback func(response *CancelCertificateForPackageRequestResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CancelCertificateForPackageRequestResponse
		var err error
		defer close(result)
		response, err = client.CancelCertificateForPackageRequest(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CancelCertificateForPackageRequestRequest is the request struct for api CancelCertificateForPackageRequest
type CancelCertificateForPackageRequestRequest struct {
	*requests.RpcRequest
	OrderId  requests.Integer `position:"Query" name:"OrderId"`
	SourceIp string           `position:"Query" name:"SourceIp"`
}

// CancelCertificateForPackageRequestResponse is the response struct for api CancelCertificateForPackageRequest
type CancelCertificateForPackageRequestResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCancelCertificateForPackageRequestRequest creates a request to invoke CancelCertificateForPackageRequest API
func CreateCancelCertificateForPackageRequestRequest() (request *CancelCertificateForPackageRequestRequest) {
	request = &CancelCertificateForPackageRequestRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cas", "2020-04-07", "CancelCertificateForPackageRequest", "cas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCancelCertificateForPackageRequestResponse creates a response to parse from CancelCertificateForPackageRequest response
func CreateCancelCertificateForPackageRequestResponse() (response *CancelCertificateForPackageRequestResponse) {
	response = &CancelCertificateForPackageRequestResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
