package cc5g

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateAuthorizationRule invokes the cc5g.UpdateAuthorizationRule API synchronously
func (client *Client) UpdateAuthorizationRule(request *UpdateAuthorizationRuleRequest) (response *UpdateAuthorizationRuleResponse, err error) {
	response = CreateUpdateAuthorizationRuleResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateAuthorizationRuleWithChan invokes the cc5g.UpdateAuthorizationRule API asynchronously
func (client *Client) UpdateAuthorizationRuleWithChan(request *UpdateAuthorizationRuleRequest) (<-chan *UpdateAuthorizationRuleResponse, <-chan error) {
	responseChan := make(chan *UpdateAuthorizationRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateAuthorizationRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateAuthorizationRuleWithCallback invokes the cc5g.UpdateAuthorizationRule API asynchronously
func (client *Client) UpdateAuthorizationRuleWithCallback(request *UpdateAuthorizationRuleRequest, callback func(response *UpdateAuthorizationRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateAuthorizationRuleResponse
		var err error
		defer close(result)
		response, err = client.UpdateAuthorizationRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateAuthorizationRuleRequest is the request struct for api UpdateAuthorizationRule
type UpdateAuthorizationRuleRequest struct {
	*requests.RpcRequest
	ClientToken              string           `position:"Query" name:"ClientToken"`
	SourceCidr               string           `position:"Query" name:"SourceCidr"`
	Destination              string           `position:"Query" name:"Destination"`
	Description              string           `position:"Query" name:"Description"`
	Protocol                 string           `position:"Query" name:"Protocol"`
	Policy                   string           `position:"Query" name:"Policy"`
	DryRun                   requests.Boolean `position:"Query" name:"DryRun"`
	AuthorizationRuleId      string           `position:"Query" name:"AuthorizationRuleId"`
	DestinationPort          string           `position:"Query" name:"DestinationPort"`
	WirelessCloudConnectorId string           `position:"Query" name:"WirelessCloudConnectorId"`
	Name                     string           `position:"Query" name:"Name"`
}

// UpdateAuthorizationRuleResponse is the response struct for api UpdateAuthorizationRule
type UpdateAuthorizationRuleResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateAuthorizationRuleRequest creates a request to invoke UpdateAuthorizationRule API
func CreateUpdateAuthorizationRuleRequest() (request *UpdateAuthorizationRuleRequest) {
	request = &UpdateAuthorizationRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CC5G", "2022-03-14", "UpdateAuthorizationRule", "fivegcc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateAuthorizationRuleResponse creates a response to parse from UpdateAuthorizationRule response
func CreateUpdateAuthorizationRuleResponse() (response *UpdateAuthorizationRuleResponse) {
	response = &UpdateAuthorizationRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
