package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetCampaign invokes the ccc.GetCampaign API synchronously
func (client *Client) GetCampaign(request *GetCampaignRequest) (response *GetCampaignResponse, err error) {
	response = CreateGetCampaignResponse()
	err = client.DoAction(request, response)
	return
}

// GetCampaignWithChan invokes the ccc.GetCampaign API asynchronously
func (client *Client) GetCampaignWithChan(request *GetCampaignRequest) (<-chan *GetCampaignResponse, <-chan error) {
	responseChan := make(chan *GetCampaignResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetCampaign(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetCampaignWithCallback invokes the ccc.GetCampaign API asynchronously
func (client *Client) GetCampaignWithCallback(request *GetCampaignRequest, callback func(response *GetCampaignResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetCampaignResponse
		var err error
		defer close(result)
		response, err = client.GetCampaign(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetCampaignRequest is the request struct for api GetCampaign
type GetCampaignRequest struct {
	*requests.RpcRequest
	InstanceId string `position:"Query" name:"InstanceId"`
	CampaignId string `position:"Query" name:"CampaignId"`
}

// GetCampaignResponse is the response struct for api GetCampaign
type GetCampaignResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	HttpStatusCode int64  `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Code           string `json:"Code" xml:"Code"`
	Data           Data   `json:"Data" xml:"Data"`
}

// CreateGetCampaignRequest creates a request to invoke GetCampaign API
func CreateGetCampaignRequest() (request *GetCampaignRequest) {
	request = &GetCampaignRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2020-07-01", "GetCampaign", "CCC", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetCampaignResponse creates a response to parse from GetCampaign response
func CreateGetCampaignResponse() (response *GetCampaignResponse) {
	response = &GetCampaignResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
