package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RemovePhoneNumberFromSkillGroups invokes the ccc.RemovePhoneNumberFromSkillGroups API synchronously
func (client *Client) RemovePhoneNumberFromSkillGroups(request *RemovePhoneNumberFromSkillGroupsRequest) (response *RemovePhoneNumberFromSkillGroupsResponse, err error) {
	response = CreateRemovePhoneNumberFromSkillGroupsResponse()
	err = client.DoAction(request, response)
	return
}

// RemovePhoneNumberFromSkillGroupsWithChan invokes the ccc.RemovePhoneNumberFromSkillGroups API asynchronously
func (client *Client) RemovePhoneNumberFromSkillGroupsWithChan(request *RemovePhoneNumberFromSkillGroupsRequest) (<-chan *RemovePhoneNumberFromSkillGroupsResponse, <-chan error) {
	responseChan := make(chan *RemovePhoneNumberFromSkillGroupsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RemovePhoneNumberFromSkillGroups(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RemovePhoneNumberFromSkillGroupsWithCallback invokes the ccc.RemovePhoneNumberFromSkillGroups API asynchronously
func (client *Client) RemovePhoneNumberFromSkillGroupsWithCallback(request *RemovePhoneNumberFromSkillGroupsRequest, callback func(response *RemovePhoneNumberFromSkillGroupsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RemovePhoneNumberFromSkillGroupsResponse
		var err error
		defer close(result)
		response, err = client.RemovePhoneNumberFromSkillGroups(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RemovePhoneNumberFromSkillGroupsRequest is the request struct for api RemovePhoneNumberFromSkillGroups
type RemovePhoneNumberFromSkillGroupsRequest struct {
	*requests.RpcRequest
	Number           string `position:"Query" name:"Number"`
	InstanceId       string `position:"Query" name:"InstanceId"`
	SkillGroupIdList string `position:"Query" name:"SkillGroupIdList"`
}

// RemovePhoneNumberFromSkillGroupsResponse is the response struct for api RemovePhoneNumberFromSkillGroups
type RemovePhoneNumberFromSkillGroupsResponse struct {
	*responses.BaseResponse
	Code           string `json:"Code" xml:"Code"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string `json:"Message" xml:"Message"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
}

// CreateRemovePhoneNumberFromSkillGroupsRequest creates a request to invoke RemovePhoneNumberFromSkillGroups API
func CreateRemovePhoneNumberFromSkillGroupsRequest() (request *RemovePhoneNumberFromSkillGroupsRequest) {
	request = &RemovePhoneNumberFromSkillGroupsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2020-07-01", "RemovePhoneNumberFromSkillGroups", "CCC", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRemovePhoneNumberFromSkillGroupsResponse creates a response to parse from RemovePhoneNumberFromSkillGroups response
func CreateRemovePhoneNumberFromSkillGroupsResponse() (response *RemovePhoneNumberFromSkillGroupsResponse) {
	response = &RemovePhoneNumberFromSkillGroupsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
