package cloud_siem

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteDataSourceLog invokes the cloud_siem.DeleteDataSourceLog API synchronously
func (client *Client) DeleteDataSourceLog(request *DeleteDataSourceLogRequest) (response *DeleteDataSourceLogResponse, err error) {
	response = CreateDeleteDataSourceLogResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteDataSourceLogWithChan invokes the cloud_siem.DeleteDataSourceLog API asynchronously
func (client *Client) DeleteDataSourceLogWithChan(request *DeleteDataSourceLogRequest) (<-chan *DeleteDataSourceLogResponse, <-chan error) {
	responseChan := make(chan *DeleteDataSourceLogResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteDataSourceLog(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteDataSourceLogWithCallback invokes the cloud_siem.DeleteDataSourceLog API asynchronously
func (client *Client) DeleteDataSourceLogWithCallback(request *DeleteDataSourceLogRequest, callback func(response *DeleteDataSourceLogResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteDataSourceLogResponse
		var err error
		defer close(result)
		response, err = client.DeleteDataSourceLog(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteDataSourceLogRequest is the request struct for api DeleteDataSourceLog
type DeleteDataSourceLogRequest struct {
	*requests.RpcRequest
	CloudCode            string `position:"Body" name:"CloudCode"`
	AccountId            string `position:"Body" name:"AccountId"`
	LogInstanceId        string `position:"Body" name:"LogInstanceId"`
	DataSourceInstanceId string `position:"Body" name:"DataSourceInstanceId"`
}

// DeleteDataSourceLogResponse is the response struct for api DeleteDataSourceLog
type DeleteDataSourceLogResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateDeleteDataSourceLogRequest creates a request to invoke DeleteDataSourceLog API
func CreateDeleteDataSourceLogRequest() (request *DeleteDataSourceLogRequest) {
	request = &DeleteDataSourceLogRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloud-siem", "2022-06-16", "DeleteDataSourceLog", "cloud-siem", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteDataSourceLogResponse creates a response to parse from DeleteDataSourceLog response
func CreateDeleteDataSourceLogResponse() (response *DeleteDataSourceLogResponse) {
	response = &DeleteDataSourceLogResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
