package cloud_siem

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeProdCount invokes the cloud_siem.DescribeProdCount API synchronously
func (client *Client) DescribeProdCount(request *DescribeProdCountRequest) (response *DescribeProdCountResponse, err error) {
	response = CreateDescribeProdCountResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeProdCountWithChan invokes the cloud_siem.DescribeProdCount API asynchronously
func (client *Client) DescribeProdCountWithChan(request *DescribeProdCountRequest) (<-chan *DescribeProdCountResponse, <-chan error) {
	responseChan := make(chan *DescribeProdCountResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeProdCount(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeProdCountWithCallback invokes the cloud_siem.DescribeProdCount API asynchronously
func (client *Client) DescribeProdCountWithCallback(request *DescribeProdCountRequest, callback func(response *DescribeProdCountResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeProdCountResponse
		var err error
		defer close(result)
		response, err = client.DescribeProdCount(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeProdCountRequest is the request struct for api DescribeProdCount
type DescribeProdCountRequest struct {
	*requests.RpcRequest
}

// DescribeProdCountResponse is the response struct for api DescribeProdCount
type DescribeProdCountResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateDescribeProdCountRequest creates a request to invoke DescribeProdCount API
func CreateDescribeProdCountRequest() (request *DescribeProdCountRequest) {
	request = &DescribeProdCountRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloud-siem", "2022-06-16", "DescribeProdCount", "cloud-siem", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeProdCountResponse creates a response to parse from DescribeProdCount response
func CreateDescribeProdCountResponse() (response *DescribeProdCountResponse) {
	response = &DescribeProdCountResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
