package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BeginContactFlowVersionModification invokes the cloudcallcenter.BeginContactFlowVersionModification API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/begincontactflowversionmodification.html
func (client *Client) BeginContactFlowVersionModification(request *BeginContactFlowVersionModificationRequest) (response *BeginContactFlowVersionModificationResponse, err error) {
	response = CreateBeginContactFlowVersionModificationResponse()
	err = client.DoAction(request, response)
	return
}

// BeginContactFlowVersionModificationWithChan invokes the cloudcallcenter.BeginContactFlowVersionModification API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/begincontactflowversionmodification.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) BeginContactFlowVersionModificationWithChan(request *BeginContactFlowVersionModificationRequest) (<-chan *BeginContactFlowVersionModificationResponse, <-chan error) {
	responseChan := make(chan *BeginContactFlowVersionModificationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BeginContactFlowVersionModification(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BeginContactFlowVersionModificationWithCallback invokes the cloudcallcenter.BeginContactFlowVersionModification API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/begincontactflowversionmodification.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) BeginContactFlowVersionModificationWithCallback(request *BeginContactFlowVersionModificationRequest, callback func(response *BeginContactFlowVersionModificationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BeginContactFlowVersionModificationResponse
		var err error
		defer close(result)
		response, err = client.BeginContactFlowVersionModification(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BeginContactFlowVersionModificationRequest is the request struct for api BeginContactFlowVersionModification
type BeginContactFlowVersionModificationRequest struct {
	*requests.RpcRequest
	ContactFlowId string `position:"Body" name:"ContactFlowId"`
	InstanceId    string `position:"Body" name:"InstanceId"`
}

// BeginContactFlowVersionModificationResponse is the response struct for api BeginContactFlowVersionModification
type BeginContactFlowVersionModificationResponse struct {
	*responses.BaseResponse
	RequestId      string      `json:"RequestId" xml:"RequestId"`
	Success        bool        `json:"Success" xml:"Success"`
	Code           string      `json:"Code" xml:"Code"`
	Message        string      `json:"Message" xml:"Message"`
	HttpStatusCode int         `json:"HttpStatusCode" xml:"HttpStatusCode"`
	ContactFlow    ContactFlow `json:"ContactFlow" xml:"ContactFlow"`
}

// CreateBeginContactFlowVersionModificationRequest creates a request to invoke BeginContactFlowVersionModification API
func CreateBeginContactFlowVersionModificationRequest() (request *BeginContactFlowVersionModificationRequest) {
	request = &BeginContactFlowVersionModificationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "BeginContactFlowVersionModification", "", "")
	request.Method = requests.POST
	return
}

// CreateBeginContactFlowVersionModificationResponse creates a response to parse from BeginContactFlowVersionModification response
func CreateBeginContactFlowVersionModificationResponse() (response *BeginContactFlowVersionModificationResponse) {
	response = &BeginContactFlowVersionModificationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
