package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateVnKnowledge invokes the cloudcallcenter.CreateVnKnowledge API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/createvnknowledge.html
func (client *Client) CreateVnKnowledge(request *CreateVnKnowledgeRequest) (response *CreateVnKnowledgeResponse, err error) {
	response = CreateCreateVnKnowledgeResponse()
	err = client.DoAction(request, response)
	return
}

// CreateVnKnowledgeWithChan invokes the cloudcallcenter.CreateVnKnowledge API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/createvnknowledge.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateVnKnowledgeWithChan(request *CreateVnKnowledgeRequest) (<-chan *CreateVnKnowledgeResponse, <-chan error) {
	responseChan := make(chan *CreateVnKnowledgeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateVnKnowledge(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateVnKnowledgeWithCallback invokes the cloudcallcenter.CreateVnKnowledge API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/createvnknowledge.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateVnKnowledgeWithCallback(request *CreateVnKnowledgeRequest, callback func(response *CreateVnKnowledgeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateVnKnowledgeResponse
		var err error
		defer close(result)
		response, err = client.CreateVnKnowledge(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateVnKnowledgeRequest is the request struct for api CreateVnKnowledge
type CreateVnKnowledgeRequest struct {
	*requests.RpcRequest
	UserUtterance     string           `position:"Query" name:"UserUtterance"`
	Interruptible     requests.Boolean `position:"Query" name:"Interruptible"`
	InstanceId        string           `position:"Query" name:"InstanceId"`
	Answer            string           `position:"Query" name:"Answer"`
	SimilarUtterances *[]string        `position:"Query" name:"SimilarUtterances"  type:"Repeated"`
	CategoryId        string           `position:"Query" name:"CategoryId"`
}

// CreateVnKnowledgeResponse is the response struct for api CreateVnKnowledge
type CreateVnKnowledgeResponse struct {
	*responses.BaseResponse
	RequestId          string `json:"RequestId" xml:"RequestId"`
	NavigationScriptId string `json:"NavigationScriptId" xml:"NavigationScriptId"`
}

// CreateCreateVnKnowledgeRequest creates a request to invoke CreateVnKnowledge API
func CreateCreateVnKnowledgeRequest() (request *CreateVnKnowledgeRequest) {
	request = &CreateVnKnowledgeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "CreateVnKnowledge", "", "")
	request.Method = requests.GET
	return
}

// CreateCreateVnKnowledgeResponse creates a response to parse from CreateVnKnowledge response
func CreateCreateVnKnowledgeResponse() (response *CreateVnKnowledgeResponse) {
	response = &CreateVnKnowledgeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
