package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetNavigatorContactFlow invokes the cloudcallcenter.GetNavigatorContactFlow API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/getnavigatorcontactflow.html
func (client *Client) GetNavigatorContactFlow(request *GetNavigatorContactFlowRequest) (response *GetNavigatorContactFlowResponse, err error) {
	response = CreateGetNavigatorContactFlowResponse()
	err = client.DoAction(request, response)
	return
}

// GetNavigatorContactFlowWithChan invokes the cloudcallcenter.GetNavigatorContactFlow API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/getnavigatorcontactflow.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetNavigatorContactFlowWithChan(request *GetNavigatorContactFlowRequest) (<-chan *GetNavigatorContactFlowResponse, <-chan error) {
	responseChan := make(chan *GetNavigatorContactFlowResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetNavigatorContactFlow(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetNavigatorContactFlowWithCallback invokes the cloudcallcenter.GetNavigatorContactFlow API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/getnavigatorcontactflow.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetNavigatorContactFlowWithCallback(request *GetNavigatorContactFlowRequest, callback func(response *GetNavigatorContactFlowResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetNavigatorContactFlowResponse
		var err error
		defer close(result)
		response, err = client.GetNavigatorContactFlow(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetNavigatorContactFlowRequest is the request struct for api GetNavigatorContactFlow
type GetNavigatorContactFlowRequest struct {
	*requests.RpcRequest
	InstanceId string `position:"Query" name:"InstanceId"`
}

// GetNavigatorContactFlowResponse is the response struct for api GetNavigatorContactFlow
type GetNavigatorContactFlowResponse struct {
	*responses.BaseResponse
	RequestId      string      `json:"RequestId" xml:"RequestId"`
	Success        bool        `json:"Success" xml:"Success"`
	Code           string      `json:"Code" xml:"Code"`
	Message        string      `json:"Message" xml:"Message"`
	HttpStatusCode int         `json:"HttpStatusCode" xml:"HttpStatusCode"`
	ContactFlow    ContactFlow `json:"ContactFlow" xml:"ContactFlow"`
}

// CreateGetNavigatorContactFlowRequest creates a request to invoke GetNavigatorContactFlow API
func CreateGetNavigatorContactFlowRequest() (request *GetNavigatorContactFlowRequest) {
	request = &GetNavigatorContactFlowRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "GetNavigatorContactFlow", "", "")
	request.Method = requests.POST
	return
}

// CreateGetNavigatorContactFlowResponse creates a response to parse from GetNavigatorContactFlow response
func CreateGetNavigatorContactFlowResponse() (response *GetNavigatorContactFlowResponse) {
	response = &GetNavigatorContactFlowResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
