package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetPrivacyNumberAccount invokes the cloudcallcenter.GetPrivacyNumberAccount API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/getprivacynumberaccount.html
func (client *Client) GetPrivacyNumberAccount(request *GetPrivacyNumberAccountRequest) (response *GetPrivacyNumberAccountResponse, err error) {
	response = CreateGetPrivacyNumberAccountResponse()
	err = client.DoAction(request, response)
	return
}

// GetPrivacyNumberAccountWithChan invokes the cloudcallcenter.GetPrivacyNumberAccount API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/getprivacynumberaccount.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetPrivacyNumberAccountWithChan(request *GetPrivacyNumberAccountRequest) (<-chan *GetPrivacyNumberAccountResponse, <-chan error) {
	responseChan := make(chan *GetPrivacyNumberAccountResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetPrivacyNumberAccount(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetPrivacyNumberAccountWithCallback invokes the cloudcallcenter.GetPrivacyNumberAccount API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/getprivacynumberaccount.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetPrivacyNumberAccountWithCallback(request *GetPrivacyNumberAccountRequest, callback func(response *GetPrivacyNumberAccountResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetPrivacyNumberAccountResponse
		var err error
		defer close(result)
		response, err = client.GetPrivacyNumberAccount(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetPrivacyNumberAccountRequest is the request struct for api GetPrivacyNumberAccount
type GetPrivacyNumberAccountRequest struct {
	*requests.RpcRequest
	ProviderId string `position:"Query" name:"ProviderId"`
}

// GetPrivacyNumberAccountResponse is the response struct for api GetPrivacyNumberAccount
type GetPrivacyNumberAccountResponse struct {
	*responses.BaseResponse
	RequestId            string               `json:"RequestId" xml:"RequestId"`
	Success              bool                 `json:"Success" xml:"Success"`
	Code                 string               `json:"Code" xml:"Code"`
	Message              string               `json:"Message" xml:"Message"`
	HttpStatusCode       int                  `json:"HttpStatusCode" xml:"HttpStatusCode"`
	PrivacyNumberAccount PrivacyNumberAccount `json:"PrivacyNumberAccount" xml:"PrivacyNumberAccount"`
}

// CreateGetPrivacyNumberAccountRequest creates a request to invoke GetPrivacyNumberAccount API
func CreateGetPrivacyNumberAccountRequest() (request *GetPrivacyNumberAccountRequest) {
	request = &GetPrivacyNumberAccountRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "GetPrivacyNumberAccount", "", "")
	request.Method = requests.POST
	return
}

// CreateGetPrivacyNumberAccountResponse creates a response to parse from GetPrivacyNumberAccount response
func CreateGetPrivacyNumberAccountResponse() (response *GetPrivacyNumberAccountResponse) {
	response = &GetPrivacyNumberAccountResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
